--
-- PostgreSQL database dump
--

SET client_encoding = 'SQL_ASCII';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: gcov_pub; Type: SCHEMA; Schema: -; Owner: gcov
--

CREATE SCHEMA gcov_pub;


ALTER SCHEMA gcov_pub OWNER TO gcov;

SET search_path = gcov_pub, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: exposed; Type: TABLE; Schema: gcov_pub; Owner: gcov; Tablespace: 
--

CREATE TABLE exposed (
    unique_obs text NOT NULL,
    ex_bare double precision,
    ex_brown double precision,
    ex_green double precision,
    points integer
);


ALTER TABLE gcov_pub.exposed OWNER TO gcov;

--
-- Name: COLUMN exposed.unique_obs; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN exposed.unique_obs IS 'Site identifier (longitude_latitude_date)
00000000_0000000_yyyymmdd';


--
-- Name: COLUMN exposed.ex_bare; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN exposed.ex_bare IS 'Exposed bare soil (BS)(%) = (crust + dist + rock + crypto)where no mid or overstorey';


--
-- Name: COLUMN exposed.ex_brown; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN exposed.ex_brown IS 'Exposed non-green or non-photosynthetic vegetation(%) = ob, od, mb, md, dry or litter';


--
-- Name: COLUMN exposed.ex_green; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN exposed.ex_green IS 'Exposed green or photosynthetic vegetation (PV) (%) = og, mg or green';


--
-- Name: COLUMN exposed.points; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN exposed.points IS 'number of transect points';


--
-- Name: fc_raw; Type: TABLE; Schema: gcov_pub; Owner: gcov; Tablespace: 
--

CREATE TABLE fc_raw (
    point integer NOT NULL,
    cr integer,
    ds integer,
    rk integer,
    gr integer,
    dr integer,
    li integer,
    cy integer,
    mg integer,
    md integer,
    mb integer,
    oic integer,
    og integer,
    od integer,
    ob integer,
    unique_obs character varying(32) NOT NULL,
    g_total integer,
    m_total integer,
    o_total integer,
    all_total integer
);


ALTER TABLE gcov_pub.fc_raw OWNER TO gcov;

--
-- Name: COLUMN fc_raw.point; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.point IS 'Transect measurement 1-300';


--
-- Name: COLUMN fc_raw.cr; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.cr IS 'Soil crust 0,1';


--
-- Name: COLUMN fc_raw.ds; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.ds IS 'Disturbed soil 0,1';


--
-- Name: COLUMN fc_raw.rk; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.rk IS 'Rock 0,1';


--
-- Name: COLUMN fc_raw.gr; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.gr IS 'Green leaf non-woody vegetation 0,1';


--
-- Name: COLUMN fc_raw.dr; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.dr IS 'Dry leaf non-woody vegetation 0,1';


--
-- Name: COLUMN fc_raw.li; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.li IS 'Litter 0,1';


--
-- Name: COLUMN fc_raw.cy; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.cy IS 'Cryptogam 0,1';


--
-- Name: COLUMN fc_raw.mg; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.mg IS 'Green leaf woody vegetation <2m 0,1';


--
-- Name: COLUMN fc_raw.md; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.md IS 'Dry leaf woody vegetation <2m 0,1';


--
-- Name: COLUMN fc_raw.mb; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.mb IS 'Branch <2m 0,1';


--
-- Name: COLUMN fc_raw.oic; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.oic IS 'In crown for live woody vegetation >2m 0,1';


--
-- Name: COLUMN fc_raw.og; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.og IS 'Green leaf woody vegetation >2m 0,1';


--
-- Name: COLUMN fc_raw.od; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.od IS 'Dry leaf woody vegetation >2m 0,1';


--
-- Name: COLUMN fc_raw.ob; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.ob IS 'Branch >2m 0,1';


--
-- Name: COLUMN fc_raw.unique_obs; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.unique_obs IS 'Site identifier(longitude_latitude_date)00000000_0000000_yyyymmdd';


--
-- Name: COLUMN fc_raw.g_total; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.g_total IS 'Only one observation for ground cover (cr+ds+rk+gr+dr+li+cy) permitted at each point 1';


--
-- Name: COLUMN fc_raw.m_total; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.m_total IS 'Zero or one observations for of woody vegetation <2m (og+od+ob) permitted at each point 0,1';


--
-- Name: COLUMN fc_raw.o_total; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.o_total IS 'Zero, one or two observations of woody vegetation >2m (oic+og+od+ob) are permitted at each point 0,1,2';


--
-- Name: COLUMN fc_raw.all_total; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN fc_raw.all_total IS 'Number of strata for each transect point (g_total + m_total + o_total) 1,2,3,4';


--
-- Name: fc_summary; Type: VIEW; Schema: gcov_pub; Owner: gcov
--

CREATE VIEW fc_summary AS
    SELECT to_char((((frank.sum_cr)::double precision / frank.tot) * (100)::double precision), '999D99'::text) AS cr, to_char((((frank.sum_ds)::double precision / frank.tot) * (100)::double precision), '999D99'::text) AS dist, to_char((((frank.sum_rk)::double precision / frank.tot) * (100)::double precision), '999D99'::text) AS rock, to_char((((frank.sum_gr)::double precision / frank.tot) * (100)::double precision), '999D99'::text) AS green, to_char((((frank.sum_dr)::double precision / frank.tot) * (100)::double precision), '999D99'::text) AS dry, to_char((((frank.sum_li)::double precision / frank.tot) * (100)::double precision), '999D99'::text) AS litter, to_char((((frank.sum_cy)::double precision / frank.tot) * (100)::double precision), '999D99'::text) AS crypto, to_char((((frank.sum_mg)::double precision / frank.tot) * (100)::double precision), '999D99'::text) AS mid_g, to_char((((frank.sum_md)::double precision / frank.tot) * (100)::double precision), '999D99'::text) AS mid_d, to_char((((frank.sum_mb)::double precision / frank.tot) * (100)::double precision), '999D99'::text) AS mid_b, to_char((((frank.sum_oic)::double precision / frank.tot) * (100)::double precision), '999D99'::text) AS in_crown, to_char((((frank.sum_og)::double precision / frank.tot) * (100)::double precision), '999D99'::text) AS over_g, to_char((((frank.sum_od)::double precision / frank.tot) * (100)::double precision), '999D99'::text) AS over_d, to_char((((frank.sum_ob)::double precision / frank.tot) * (100)::double precision), '999D99'::text) AS over_b, frank.unique_obs FROM (SELECT (((((((sums.sum_cr + sums.sum_ds) + sums.sum_rk) + sums.sum_gr) + sums.sum_dr) + sums.sum_li) + sums.sum_cy))::double precision AS tot, sums.sum_tot_gr, sums.sum_ov_ms_gr, sums.sum_cr, sums.sum_ds, sums.sum_rk, sums.sum_gr, sums.sum_dr, sums.sum_li, sums.sum_cy, sums.sum_mb, sums.sum_mg, sums.sum_md, sums.sum_oic, sums.sum_og, sums.sum_od, sums.sum_ob, sums.unique_obs FROM (SELECT count((((fc_raw.gr = 1) OR (fc_raw.mg = 1)) OR (fc_raw.og = 1))) AS sum_tot_gr, count(((fc_raw.mg = 1) OR (fc_raw.og = 1))) AS sum_ov_ms_gr, count(fc_raw.cr) AS sum_cr, count(fc_raw.ds) AS sum_ds, count(fc_raw.rk) AS sum_rk, count(fc_raw.gr) AS sum_gr, count(fc_raw.dr) AS sum_dr, count(fc_raw.li) AS sum_li, count(fc_raw.cy) AS sum_cy, count(fc_raw.mg) AS sum_mg, count(fc_raw.md) AS sum_md, count(fc_raw.mb) AS sum_mb, count(fc_raw.oic) AS sum_oic, count(fc_raw.og) AS sum_og, count(fc_raw.od) AS sum_od, count(fc_raw.ob) AS sum_ob, fc_raw.unique_obs FROM fc_raw fc_raw GROUP BY fc_raw.unique_obs) sums) frank WHERE (frank.tot > (0)::double precision);


ALTER TABLE gcov_pub.fc_summary OWNER TO gcov;

--
-- Name: fc3; Type: VIEW; Schema: gcov_pub; Owner: gcov
--

CREATE VIEW fc3 AS
    SELECT ((((fc_summary.cr)::double precision + (fc_summary.dist)::double precision) + (fc_summary.rock)::double precision) + (fc_summary.crypto)::double precision) AS bare, fc_summary.green, ((fc_summary.dry)::double precision + (fc_summary.litter)::double precision) AS brown, (((fc_summary.green)::double precision + (fc_summary.dry)::double precision) + (fc_summary.litter)::double precision) AS cover, fc_summary.unique_obs FROM fc_summary;


ALTER TABLE gcov_pub.fc3 OWNER TO gcov;

SET default_with_oids = false;

--
-- Name: photos; Type: TABLE; Schema: gcov_pub; Owner: gcov; Tablespace: 
--

CREATE TABLE photos (
    code character varying(40) NOT NULL,
    unique_obs character varying(32),
    site_name character varying(20),
    state character varying(3),
    crop character varying(3),
    name character varying(3),
    transect integer,
    direction integer,
    cardinal_direction character varying(10),
    weblink character varying(255)
);


ALTER TABLE gcov_pub.photos OWNER TO gcov;

--
-- Name: COLUMN photos.code; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN photos.code IS 'Primary key (unique_obs,name)';


--
-- Name: COLUMN photos.unique_obs; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN photos.unique_obs IS 'Site identifier (longitude_latitude_date)00000000_0000000_yyyymmdd';


--
-- Name: COLUMN photos.site_name; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN photos.site_name IS 'Name of the site e.g. Vic1001';


--
-- Name: COLUMN photos.state; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN photos.state IS 'State abbreviation e.g. NSW';


--
-- Name: COLUMN photos.crop; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN photos.crop IS 'Site cropped or not Yes,No';


--
-- Name: COLUMN photos.name; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN photos.name IS 'G1=centre down, L1=1st, L2=2nd, L3=3rd, L4=4th, L5=5th, L6=6th';


--
-- Name: COLUMN photos.transect; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN photos.transect IS 'Which transect the image shows';


--
-- Name: COLUMN photos.direction; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN photos.direction IS 'Site orientation in degrees 0-360';


--
-- Name: COLUMN photos.cardinal_direction; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN photos.cardinal_direction IS 'Direction text';


--
-- Name: COLUMN photos.weblink; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN photos.weblink IS 'Link to online photo library';


SET default_with_oids = true;

--
-- Name: site_desc; Type: TABLE; Schema: gcov_pub; Owner: gcov; Tablespace: 
--

CREATE TABLE site_desc (
    publish character varying(3),
    unique_obs character varying(32) NOT NULL,
    site_name character varying(20),
    state character varying(3),
    site_desc character varying(255),
    date_collect integer,
    "time" time(5) without time zone,
    purpose character varying(25),
    protocol character varying(20),
    revisit character varying(3),
    "zone" integer,
    datum character varying(6),
    east_c real,
    north_c real,
    diff_gps character varying(3),
    bear_t1 integer,
    bear_t2 integer,
    bear_t3 integer,
    slope integer,
    aspect integer,
    landuse character varying(40),
    alumv7 integer,
    commod character varying(20),
    crop character varying(3),
    management character varying(50),
    growth character varying(15),
    spectra character varying(3),
    biomass real,
    biomass_method text,
    grass_m real,
    fire character varying(55),
    perm_veg character varying(15),
    overstorey real,
    veg1st_o character varying(55),
    veg1stpc_o integer,
    veg2nd_o character varying(55),
    veg2ndpc_o integer,
    veg3rd_o character varying(55),
    veg3rdpc_o integer,
    veg1st_m character varying(55),
    veg1stpc_m integer,
    veg2nd_m character varying(55),
    veg2ndpc_m integer,
    veg3rd_m character varying(55),
    veg3rdpc_m integer,
    veg1st_g character varying(55),
    veg1stpc_g integer,
    veg2nd_g character varying(55),
    veg2ndpc_g integer,
    veg3rd_g character varying(55),
    veg3rdpc_g integer,
    prism1 real,
    live1 integer,
    dead1 integer,
    conv1 real,
    prism2 real,
    live2 integer,
    dead2 integer,
    conv2 real,
    prism3 real,
    live3 integer,
    dead3 integer,
    conv3 real,
    prism4 real,
    live4 integer,
    dead4 integer,
    conv4 real,
    prism5 real,
    live5 integer,
    dead5 integer,
    conv5 real,
    prism6 real,
    live6 integer,
    dead6 integer,
    conv6 real,
    prism7 real,
    live7 integer,
    dead7 integer,
    conv7 real,
    total_live real,
    erosion character varying(50),
    wind_erosion character varying(50),
    scald_erosion character varying(50),
    sheet_erosion character varying(50),
    rill_erosion character varying(50),
    gully_erosion character varying(55),
    deposits character varying(50),
    amount character varying(50),
    micro_relief character varying(50),
    vertical_m real,
    horizontal_m real,
    s_cond1 character varying(50),
    s_cond2 character varying(50),
    s_cond3 character varying(50),
    s_stngth character varying(50),
    s_cracks character varying(50),
    disturb1 character varying(50),
    disturb2 character varying(50),
    disturb3 character varying(50),
    crust_d_h character varying(7),
    dist_d_h character varying(7),
    crust_w_h character varying(7),
    dist_w_h character varying(7),
    crust_d_v numeric(2,1),
    dist_d_v numeric(2,1),
    crust_w_v numeric(2,1),
    dist_w_v numeric(2,1),
    crust_d_c numeric(2,1),
    dist_d_c numeric(2,1),
    crust_w_c numeric(2,1),
    dist_w_c numeric(2,1),
    crypto character varying(10),
    crypto_mc character varying(50),
    crypto_bc character varying(50),
    crypto_w_d character varying(10),
    rock1st_h character varying(20),
    rock2nd_h character varying(50),
    rock3rd_h character varying(20),
    rock1st_v numeric(2,1),
    rock2nd_v numeric(2,1),
    rock3rd_v numeric(2,1),
    rock1st_c numeric(2,1),
    rock2nd_c numeric(2,1),
    rock3rd_c numeric(2,1),
    rock_lag character varying(40),
    rock_lag_s character varying(30),
    soilclr1_cd character varying(10),
    soilclr2_dd character varying(10),
    soilclr3_cw character varying(10),
    soilclr4_dw character varying(10),
    soil_col_max character varying(10),
    wet_dry character varying(10)
);


ALTER TABLE gcov_pub.site_desc OWNER TO gcov;

--
-- Name: COLUMN site_desc.publish; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.publish IS 'Consent for public release of data (if "No": not published) Yes,No';


--
-- Name: COLUMN site_desc.unique_obs; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.unique_obs IS 'Site identifier (longitude_latitude_date) 00000000_0000000_yyyymmdd';


--
-- Name: COLUMN site_desc.site_name; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.site_name IS 'Name of site e.g. Vic1001';


--
-- Name: COLUMN site_desc.state; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.state IS 'State abbreviation e.g. NSW';


--
-- Name: COLUMN site_desc.site_desc; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.site_desc IS 'Details of land use, management or recent natural events';


--
-- Name: COLUMN site_desc.date_collect; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.date_collect IS 'Date site completed as year, month, day yyyymmdd';


--
-- Name: COLUMN site_desc."time"; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc."time" IS 'Time site started in 24 hour time hh:mm';


--
-- Name: COLUMN site_desc.purpose; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.purpose IS 'Purpose of data collection';


--
-- Name: COLUMN site_desc.protocol; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.protocol IS 'Code describing the transect layout and attributes collected 
P1 = 300 points from 3 transects in star pattern for pastoral or rangelands 
P2 = 200 points from 2 transects crossed for crops and vegetation in rows';


--
-- Name: COLUMN site_desc.revisit; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.revisit IS 'If site has been revisted using the same protocol Yes,No';


--
-- Name: COLUMN site_desc."zone"; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc."zone" IS 'Zone as per MGA94 or UTM';


--
-- Name: COLUMN site_desc.datum; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.datum IS 'Coordinate system, WGS84 or GDA94';


--
-- Name: COLUMN site_desc.east_c; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.east_c IS 'Transect centre easting';


--
-- Name: COLUMN site_desc.north_c; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.north_c IS 'Transect centre northing';


--
-- Name: COLUMN site_desc.diff_gps; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.diff_gps IS 'Whether a differential GPS was used for a more accurate location';


--
-- Name: COLUMN site_desc.bear_t1; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.bear_t1 IS 'Transect 1 bearing in degrees 0-360';


--
-- Name: COLUMN site_desc.bear_t2; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.bear_t2 IS 'Transect 2 bearing in degrees 0-360';


--
-- Name: COLUMN site_desc.bear_t3; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.bear_t3 IS 'Transect 3 bearing in degrees 0-360';


--
-- Name: COLUMN site_desc.slope; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.slope IS 'Slope of site in per cent 0-100';


--
-- Name: COLUMN site_desc.aspect; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.aspect IS 'Horizontal direction in which the slope faces in degrees 0-360';


--
-- Name: COLUMN site_desc.landuse; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.landuse IS 'ALUM v7 tertiary class';


--
-- Name: COLUMN site_desc.alumv7; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.alumv7 IS 'ALUMv7 tertiary code, no decimals e.g. 331 100-663';


--
-- Name: COLUMN site_desc.commod; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.commod IS 'Commodity name';


--
-- Name: COLUMN site_desc.crop; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.crop IS 'Site cropped or not Yes,No';


--
-- Name: COLUMN site_desc.management; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.management IS 'The current management phase for the vegetation present, including litter (interpreted with growth phase) 
Cultivated, 
Grazed, 
Incorporated, 
Mulched, 
Sprayed, 
Standing/none, 
Other';


--
-- Name: COLUMN site_desc.growth; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.growth IS 'Growth phase for the majority of plants observed
Establishment,
Immature/growing,
Mature,
Senscence/residue
None';


--
-- Name: COLUMN site_desc.spectra; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.spectra IS 'Whether field spectra was collected Yes,No';


--
-- Name: COLUMN site_desc.biomass; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.biomass IS 'Estimate of standing non-woody ground cover biomass (kg/ha)';


--
-- Name: COLUMN site_desc.biomass_method; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.biomass_method IS 'Method used to measure biomass 
Visual
Photo standards
Visual and photo standards
Quantitative';


--
-- Name: COLUMN site_desc.grass_m; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.grass_m IS 'Average non-woody vegetation height in metres (m)';


--
-- Name: COLUMN site_desc.fire; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.fire IS 'Recent or severe fire
0-No evidence
1-Minor burn (<5% site or >3 years)
2-Recent/major burn (>5% site or < 3 years)';


--
-- Name: COLUMN site_desc.perm_veg; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.perm_veg IS 'Percentage of perennial grass cover 
0-5%, 6-25%, 26-50%, 51-75%, 76-100%';


--
-- Name: COLUMN site_desc.overstorey; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.overstorey IS 'Average woody vegetation height (m)';


--
-- Name: COLUMN site_desc.veg1st_o; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg1st_o IS 'Most dominant species by biomass for woody vegetation >2m';


--
-- Name: COLUMN site_desc.veg1stpc_o; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg1stpc_o IS 'Occurence by biomass of the most dominant woody vegetation >2m species (%)';


--
-- Name: COLUMN site_desc.veg2nd_o; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg2nd_o IS 'Second most dominant species by biomass for woody vegetation >2m';


--
-- Name: COLUMN site_desc.veg2ndpc_o; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg2ndpc_o IS 'Occurence by biomass of the second most dominant woody vegetation >2m species (%)';


--
-- Name: COLUMN site_desc.veg3rd_o; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg3rd_o IS 'Third most dominant species by biomass for woody vegetation >2m';


--
-- Name: COLUMN site_desc.veg3rdpc_o; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg3rdpc_o IS 'Occurence by biomass of the third most dominant woody vegetation >2m species (%)';


--
-- Name: COLUMN site_desc.veg1st_m; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg1st_m IS 'Most dominant species by biomass for woody vegetation <2m';


--
-- Name: COLUMN site_desc.veg1stpc_m; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg1stpc_m IS 'Occurence by biomass of the most dominant woody vegetation <2m species (%)';


--
-- Name: COLUMN site_desc.veg2nd_m; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg2nd_m IS 'Second most dominant species by biomass for woody vegetation <2m';


--
-- Name: COLUMN site_desc.veg2ndpc_m; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg2ndpc_m IS 'Occurence by biomass of the second most dominant woody vegetation <2m species (%)';


--
-- Name: COLUMN site_desc.veg3rd_m; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg3rd_m IS 'Third most dominant species by biomass for woody vegetation <2m';


--
-- Name: COLUMN site_desc.veg3rdpc_m; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg3rdpc_m IS 'Occurence by biomass of the third most dominant woody vegetation <2m species (%)';


--
-- Name: COLUMN site_desc.veg1st_g; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg1st_g IS 'Most dominant species by biomass for the non-woody ground layer';


--
-- Name: COLUMN site_desc.veg1stpc_g; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg1stpc_g IS 'Occurence by biomass of the most dominant non-woody species (%)';


--
-- Name: COLUMN site_desc.veg2nd_g; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg2nd_g IS 'Second most dominant species by biomass for the non-woody ground layer';


--
-- Name: COLUMN site_desc.veg2ndpc_g; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg2ndpc_g IS 'Occurence by biomass of the second most dominant non-woody species (%)';


--
-- Name: COLUMN site_desc.veg3rd_g; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg3rd_g IS 'Third most dominant species by biomass for the non-woody ground layer';


--
-- Name: COLUMN site_desc.veg3rdpc_g; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.veg3rdpc_g IS 'Occurence by biomass of the third most dominant non-woody species (%)';


--
-- Name: COLUMN site_desc.prism1; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.prism1 IS 'Prism factor used for tree basal area at point 1 on the transect';


--
-- Name: COLUMN site_desc.live1; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.live1 IS 'Number of live trees inside area at tree basal area point 1';


--
-- Name: COLUMN site_desc.dead1; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.dead1 IS 'Number of dead trees inside area at tree basal area point 1';


--
-- Name: COLUMN site_desc.conv1; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.conv1 IS 'Converted tree basal area value (prism x live) for point 1 ';


--
-- Name: COLUMN site_desc.prism2; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.prism2 IS 'Prism factor used for tree basal area at point 2 on the transect';


--
-- Name: COLUMN site_desc.live2; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.live2 IS 'Number of live trees inside area at tree basal area point 2';


--
-- Name: COLUMN site_desc.dead2; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.dead2 IS 'Number of dead trees inside area at tree basal area point 2';


--
-- Name: COLUMN site_desc.conv2; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.conv2 IS 'Converted tree basal area value (prism x live) for point 2';


--
-- Name: COLUMN site_desc.prism3; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.prism3 IS 'Prism factor used for tree basal area at point 3 on the transect';


--
-- Name: COLUMN site_desc.live3; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.live3 IS 'Number of live trees inside area at tree basal area point 3';


--
-- Name: COLUMN site_desc.dead3; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.dead3 IS 'Number of dead trees inside area at tree basal area point 3';


--
-- Name: COLUMN site_desc.conv3; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.conv3 IS 'Converted tree basal area value (prism x live) for point 3';


--
-- Name: COLUMN site_desc.prism4; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.prism4 IS 'Prism factor used for tree basal area at point 4 on the transect';


--
-- Name: COLUMN site_desc.live4; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.live4 IS 'Number of live trees inside area at tree basal area point 4';


--
-- Name: COLUMN site_desc.dead4; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.dead4 IS 'Number of dead trees inside area at tree basal area point 4';


--
-- Name: COLUMN site_desc.conv4; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.conv4 IS 'Converted tree basal area value (prism x live) for point 4';


--
-- Name: COLUMN site_desc.prism5; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.prism5 IS 'Prism factor used for tree basal area at point 5 on the transect';


--
-- Name: COLUMN site_desc.live5; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.live5 IS 'Number of live trees inside area at tree basal area point 5';


--
-- Name: COLUMN site_desc.dead5; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.dead5 IS 'Number of dead trees inside area at tree basal area point 5';


--
-- Name: COLUMN site_desc.conv5; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.conv5 IS 'Converted tree basal area value (prism x live) for point 5';


--
-- Name: COLUMN site_desc.prism6; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.prism6 IS 'Prism factor used for tree basal area at point 6 on the transect';


--
-- Name: COLUMN site_desc.live6; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.live6 IS 'Number of live trees inside area at tree basal area point 6';


--
-- Name: COLUMN site_desc.dead6; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.dead6 IS 'Number of dead trees inside area at tree basal area point 6';


--
-- Name: COLUMN site_desc.conv6; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.conv6 IS 'Converted tree basal area value (prism x live) for point 6';


--
-- Name: COLUMN site_desc.prism7; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.prism7 IS 'Prism factor used for tree basal area at point 7 on the transect';


--
-- Name: COLUMN site_desc.live7; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.live7 IS 'Number of live trees inside area at tree basal area point 7';


--
-- Name: COLUMN site_desc.dead7; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.dead7 IS 'Number of dead trees inside area at tree basal area point 7';


--
-- Name: COLUMN site_desc.conv7; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.conv7 IS 'Converted tree basal area value (prism x live) for point 7';


--
-- Name: COLUMN site_desc.total_live; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.total_live IS 'Average (live) tree basal area (total converted / 7) m2/ha';


--
-- Name: COLUMN site_desc.erosion; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.erosion IS 'State of erosion
N - None
A - Active
S - Stabilised
P - Partly stabilised';


--
-- Name: COLUMN site_desc.wind_erosion; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.wind_erosion IS 'Wind erosion severity
0 - None
1 - Minor
2 - Moderate
3 - Severe
4 - Very severe';


--
-- Name: COLUMN site_desc.scald_erosion; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.scald_erosion IS 'Scald erosion by wind and/or water severity
0 - None
1 - Minor (<5% of site)
2 - Moderate (5-50% of site)
3 - Severe (>50% of site)';


--
-- Name: COLUMN site_desc.sheet_erosion; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.sheet_erosion IS 'Sheet erosion by water severity
0 - None
1 - Minor
2 - Moderate
3 - Severe';


--
-- Name: COLUMN site_desc.rill_erosion; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.rill_erosion IS 'Rill erosion by water severity
0 - None
1 - Minor (occasional)
2 - Moderate (common)
3 - Severe (corrugated)';


--
-- Name: COLUMN site_desc.gully_erosion; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.gully_erosion IS 'Gully erosion by water severity
0 - None
1 - Minor (isolated)
2 - Moderate (restricted to drainage lines)
3 - Severe (branch away from primary drainage lines)';


--
-- Name: COLUMN site_desc.deposits; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.deposits IS 'Size of deposited materials
Sand (<2mm)
Gravel (2-60mm)
Stones (>60mm)';


--
-- Name: COLUMN site_desc.amount; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.amount IS 'Abundance of deposited materials
0 - None
1 - Very few (<2%)
2 - Few (2-10%)
3 - Common (10-20%)
4 - Many (20-50%)
5 - Abundant (50-90%)
6 - Very abundant (>90%)';


--
-- Name: COLUMN site_desc.micro_relief; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.micro_relief IS 'Surface smoothness, mounds, depressions, furrows
0 - Smooth (<3mm variation)
D - Depressions,
M - Mounds
C - Cropping rows/furrows';


--
-- Name: COLUMN site_desc.vertical_m; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.vertical_m IS 'Interval between base and crest of surface features (m)';


--
-- Name: COLUMN site_desc.horizontal_m; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.horizontal_m IS 'Horizontal distance between crests of surface features (m)';


--
-- Name: COLUMN site_desc.s_cond1; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.s_cond1 IS 'Soil surface condition when dry 1';


--
-- Name: COLUMN site_desc.s_cond2; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.s_cond2 IS 'Soil surface condition when dry 2';


--
-- Name: COLUMN site_desc.s_cond3; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.s_cond3 IS 'Soil surface condition when dry 3';


--
-- Name: COLUMN site_desc.s_stngth; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.s_stngth IS 'Surface soil strength';


--
-- Name: COLUMN site_desc.s_cracks; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.s_cracks IS 'Size of surface cracks ';


--
-- Name: COLUMN site_desc.disturb1; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.disturb1 IS 'Primary biotic agent causing soil surface relief disturbance';


--
-- Name: COLUMN site_desc.disturb2; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.disturb2 IS 'Secondary biotic agent causing soil surface relief disturbance';


--
-- Name: COLUMN site_desc.disturb3; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.disturb3 IS 'Tertiary biotic agent causing soil surface relief disturbance';


--
-- Name: COLUMN site_desc.crust_d_h; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.crust_d_h IS 'Dry soil crust colour  (Munsell hue)';


--
-- Name: COLUMN site_desc.dist_d_h; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.dist_d_h IS 'Dry disturbed soil colour  (Munsell hue)';


--
-- Name: COLUMN site_desc.crust_w_h; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.crust_w_h IS 'Wet soil crust colour  (Munsell hue)';


--
-- Name: COLUMN site_desc.dist_w_h; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.dist_w_h IS 'Wet disturbed soil colour  (Munsell hue)';


--
-- Name: COLUMN site_desc.crust_d_v; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.crust_d_v IS 'Dry soil crust colour  (Munsell value)';


--
-- Name: COLUMN site_desc.dist_d_v; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.dist_d_v IS 'Dry distrubed soil colour  (Munsell value)';


--
-- Name: COLUMN site_desc.crust_w_v; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.crust_w_v IS 'Wet soil crust colour  (Munsell value)';


--
-- Name: COLUMN site_desc.dist_w_v; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.dist_w_v IS 'Wet disturbed soil colour  (Munsell value)';


--
-- Name: COLUMN site_desc.crust_d_c; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.crust_d_c IS 'Dry soil crust colour  (Munsell chroma)';


--
-- Name: COLUMN site_desc.dist_d_c; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.dist_d_c IS 'Dry disturbed soil crust colour  (Munsell chroma)';


--
-- Name: COLUMN site_desc.crust_w_c; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.crust_w_c IS 'Wet soil crust colour  (Munsell chroma)';


--
-- Name: COLUMN site_desc.dist_w_c; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.dist_w_c IS 'Wet disturbed soil colour  (Munsell chroma)';


--
-- Name: COLUMN site_desc.crypto; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.crypto IS 'Cryptogam cover (%)';


--
-- Name: COLUMN site_desc.crypto_mc; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.crypto_mc IS 'Cryptogam colour (Munsell hue, value, chroma)';


--
-- Name: COLUMN site_desc.crypto_bc; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.crypto_bc IS 'Cryptogam colour (basic colour)';


--
-- Name: COLUMN site_desc.crypto_w_d; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.crypto_w_d IS 'Cryptogam wet or dry';


--
-- Name: COLUMN site_desc.rock1st_h; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.rock1st_h IS 'Most dominant rock colour (Munsell hue)';


--
-- Name: COLUMN site_desc.rock2nd_h; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.rock2nd_h IS 'Second most dominant rock colour (Munsell hue)';


--
-- Name: COLUMN site_desc.rock3rd_h; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.rock3rd_h IS 'Third most dominant rock colour (Munsell hue)';


--
-- Name: COLUMN site_desc.rock1st_v; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.rock1st_v IS 'Most dominant rock colour (Munsell value)';


--
-- Name: COLUMN site_desc.rock2nd_v; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.rock2nd_v IS 'Second dominant rock colour (Munsell value)';


--
-- Name: COLUMN site_desc.rock3rd_v; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.rock3rd_v IS 'Third dominant rock colour (Munsell value)';


--
-- Name: COLUMN site_desc.rock1st_c; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.rock1st_c IS 'Most dominant rock colour (Munsell chroma)';


--
-- Name: COLUMN site_desc.rock2nd_c; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.rock2nd_c IS 'Second dominant rock colour (Munsell chroma)';


--
-- Name: COLUMN site_desc.rock3rd_c; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.rock3rd_c IS 'Third dominant rock colour (Munsell chroma)';


--
-- Name: COLUMN site_desc.rock_lag; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.rock_lag IS 'Abundance of rock/lag (%)';


--
-- Name: COLUMN site_desc.rock_lag_s; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.rock_lag_s IS 'Average fragment size';


--
-- Name: COLUMN site_desc.soilclr1_cd; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.soilclr1_cd IS 'Basic soil colour for dry soil crust';


--
-- Name: COLUMN site_desc.soilclr2_dd; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.soilclr2_dd IS 'Basic soil colour for dry disturbed soil';


--
-- Name: COLUMN site_desc.soilclr3_cw; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.soilclr3_cw IS 'Basic soil colour for wet soil crust';


--
-- Name: COLUMN site_desc.soilclr4_dw; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.soilclr4_dw IS 'Basic soil colour for wet disturbed soil';


--
-- Name: COLUMN site_desc.soil_col_max; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.soil_col_max IS 'Most represented soil colour';


--
-- Name: COLUMN site_desc.wet_dry; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN site_desc.wet_dry IS 'Whether a dry soil colour was given';


SET default_with_oids = false;

--
-- Name: sites_geom; Type: TABLE; Schema: gcov_pub; Owner: gcov; Tablespace: 
--

CREATE TABLE sites_geom (
    "OBJECTID" character varying(10) NOT NULL,
    site_name character varying(20),
    state character varying(5),
    latitude double precision,
    longitude double precision,
    unique_obs character varying(32) NOT NULL,
    geom public.geometry
);


ALTER TABLE gcov_pub.sites_geom OWNER TO gcov;

--
-- Name: COLUMN sites_geom.site_name; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN sites_geom.site_name IS 'Name of the site e.g. Vic1001';


--
-- Name: COLUMN sites_geom.state; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN sites_geom.state IS 'State abbreviations e.g. NSW';


--
-- Name: COLUMN sites_geom.latitude; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN sites_geom.latitude IS 'Latitude';


--
-- Name: COLUMN sites_geom.longitude; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN sites_geom.longitude IS 'Longitude';


--
-- Name: COLUMN sites_geom.unique_obs; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN sites_geom.unique_obs IS 'Site identifier (longitude_latitude_date) 00000000_0000000_yyyymmdd';


--
-- Name: COLUMN sites_geom.geom; Type: COMMENT; Schema: gcov_pub; Owner: gcov
--

COMMENT ON COLUMN sites_geom.geom IS 'Point geometry (latitude,longitude in WGS84)';


--
-- Name: sum_check; Type: VIEW; Schema: gcov_pub; Owner: gcov
--

CREATE VIEW sum_check AS
    SELECT fc_summary.unique_obs, (((((((fc_summary.cr)::double precision + (fc_summary.dist)::double precision) + (fc_summary.rock)::double precision) + (fc_summary.green)::double precision) + (fc_summary.dry)::double precision) + (fc_summary.litter)::double precision) + (fc_summary.crypto)::double precision) AS ground, (((fc_summary.mid_g)::double precision + (fc_summary.mid_d)::double precision) + (fc_summary.mid_b)::double precision) AS mid, ((((fc_summary.in_crown)::double precision + (fc_summary.over_g)::double precision) + (fc_summary.over_d)::double precision) + (fc_summary.over_b)::double precision) AS over, ((((((((((((((fc_summary.cr)::double precision + (fc_summary.dist)::double precision) + (fc_summary.rock)::double precision) + (fc_summary.green)::double precision) + (fc_summary.dry)::double precision) + (fc_summary.litter)::double precision) + (fc_summary.crypto)::double precision) + (fc_summary.mid_g)::double precision) + (fc_summary.mid_d)::double precision) + (fc_summary.mid_b)::double precision) + (fc_summary.in_crown)::double precision) + (fc_summary.over_g)::double precision) + (fc_summary.over_d)::double precision) + (fc_summary.over_b)::double precision) AS total FROM fc_summary;


ALTER TABLE gcov_pub.sum_check OWNER TO gcov;

--
-- Data for Name: exposed; Type: TABLE DATA; Schema: gcov_pub; Owner: gcov
--

INSERT INTO exposed VALUES ('11404294_2435553_20111018', 100, 0, 0, 300);
INSERT INTO exposed VALUES ('11404614_2435705_20111018', 35.670000000000002, 42, 22.329999999999998, 300);
INSERT INTO exposed VALUES ('11405667_2438212_20111018', 34.670000000000002, 59.329999999999998, 6, 300);
INSERT INTO exposed VALUES ('11423372_2557730_20111019', 18, 78, 4, 300);
INSERT INTO exposed VALUES ('11429952_2553666_20111019', 50.329999999999998, 44.670000000000002, 5, 300);
INSERT INTO exposed VALUES ('11432693_2577788_20111020', 43.329999999999998, 44.670000000000002, 12, 300);
INSERT INTO exposed VALUES ('11433437_2575962_20111019', 31.329999999999998, 41.670000000000002, 27, 300);
INSERT INTO exposed VALUES ('11435713_2542933_20111019', 48.329999999999998, 47.670000000000002, 4, 300);
INSERT INTO exposed VALUES ('11436649_2532498_20111019', 55.329999999999998, 39.329999999999998, 5.3300000000000001, 300);
INSERT INTO exposed VALUES ('11446765_2574846_20111020', 51.329999999999998, 41, 7.6699999999999999, 300);
INSERT INTO exposed VALUES ('11448939_2575056_20111020', 38, 47.670000000000002, 14.33, 300);
INSERT INTO exposed VALUES ('11449658_2575100_20111020', 52.670000000000002, 38.329999999999998, 9, 300);
INSERT INTO exposed VALUES ('11523869_2885908_20110516', 60.5, 39.5, 0, 200);
INSERT INTO exposed VALUES ('11525063_2838692_20110517', 57, 43, 0, 200);
INSERT INTO exposed VALUES ('11525569_2839946_20110517', 33, 66.5, 0.5, 200);
INSERT INTO exposed VALUES ('11541568_3012799_20120626', 27.5, 26, 46.5, 200);
INSERT INTO exposed VALUES ('11542081_3012737_20120626', 11, 35, 54, 200);
INSERT INTO exposed VALUES ('11543775_2834874_20110517', 90.5, 9.5, 0, 200);
INSERT INTO exposed VALUES ('11544194_2841099_20110517', 38, 62, 0, 200);
INSERT INTO exposed VALUES ('11547087_2834287_20110517', 61.5, 38.5, 0, 200);
INSERT INTO exposed VALUES ('11548338_2840215_20110517', 48, 51.329999999999998, 0.67000000000000004, 300);
INSERT INTO exposed VALUES ('11677575_2102972_20110822', 44.329999999999998, 42.670000000000002, 13, 300);
INSERT INTO exposed VALUES ('11681968_2097839_20110822', 37.329999999999998, 54.329999999999998, 8.3300000000000001, 300);
INSERT INTO exposed VALUES ('11700941_2525084_20120927', 80, 19.670000000000002, 0.33000000000000002, 300);
INSERT INTO exposed VALUES ('11707977_2510824_20120927', 57.670000000000002, 40.329999999999998, 2, 300);
INSERT INTO exposed VALUES ('11711760_2161164_20110823', 59.670000000000002, 19.329999999999998, 21, 300);
INSERT INTO exposed VALUES ('11714936_2162546_20110822', 46, 33, 21, 300);
INSERT INTO exposed VALUES ('11724624_2080004_20110822', 53.670000000000002, 44, 2.3300000000000001, 300);
INSERT INTO exposed VALUES ('11743025_2107179_20110823', 71.329999999999998, 25.670000000000002, 3, 300);
INSERT INTO exposed VALUES ('11750816_3462149_20120620', 28, 31.5, 40.5, 200);
INSERT INTO exposed VALUES ('11751335_3462168_20120620', 16, 36.5, 47.5, 200);
INSERT INTO exposed VALUES ('11752842_2784146_20120911', 50.670000000000002, 38, 11.33, 300);
INSERT INTO exposed VALUES ('11753858_3462189_20120620', 0.5, 14, 85.5, 200);
INSERT INTO exposed VALUES ('11759773_2791162_20120911', 51.670000000000002, 35, 13.33, 300);
INSERT INTO exposed VALUES ('11762624_3370103_20120610', 56.5, 25.5, 18, 200);
INSERT INTO exposed VALUES ('11764760_3369751_20120619', 13, 42.5, 44.5, 200);
INSERT INTO exposed VALUES ('11765761_3369063_20120620', 45.5, 7, 47.5, 200);
INSERT INTO exposed VALUES ('11768923_2797080_20120911', 75, 21.329999999999998, 3.6699999999999999, 300);
INSERT INTO exposed VALUES ('11777063_2801033_20120911', 43.329999999999998, 34.329999999999998, 22.329999999999998, 300);
INSERT INTO exposed VALUES ('11778449_2801251_20120911', 47.670000000000002, 43, 9.3300000000000001, 300);
INSERT INTO exposed VALUES ('11785078_2808471_20120910', 75.670000000000002, 15.67, 8.6699999999999999, 300);
INSERT INTO exposed VALUES ('11802454_2561957_20120927', 63.329999999999998, 36, 0.67000000000000004, 300);
INSERT INTO exposed VALUES ('11820653_3147705_20120627', 15.5, 66, 18.5, 200);
INSERT INTO exposed VALUES ('11820728_2601142_20120927', 44, 51.329999999999998, 4.6699999999999999, 300);
INSERT INTO exposed VALUES ('11821245_3149108_20101012', 39, 48, 13, 200);
INSERT INTO exposed VALUES ('11821291_3149350_20101012', 36.5, 56, 7.5, 200);
INSERT INTO exposed VALUES ('11822302_3147883_20120627', 70.5, 5.5, 24, 200);
INSERT INTO exposed VALUES ('11822867_3150279_20101011', 52, 45.5, 2.5, 200);
INSERT INTO exposed VALUES ('11829367_2610653_20120927', 68.329999999999998, 29.329999999999998, 2.3300000000000001, 300);
INSERT INTO exposed VALUES ('11857083_2488166_20120926', 94, 6, 0, 300);
INSERT INTO exposed VALUES ('11857372_2487689_20120926', 77.670000000000002, 22.329999999999998, 0, 300);
INSERT INTO exposed VALUES ('11863570_2489981_20120926', 58.329999999999998, 37.329999999999998, 4.3300000000000001, 300);
INSERT INTO exposed VALUES ('11867260_2491522_20120926', 77.670000000000002, 22, 0.33000000000000002, 300);
INSERT INTO exposed VALUES ('11867540_2491287_20120926', 45, 55, 0, 300);
INSERT INTO exposed VALUES ('11893901_2800637_20120912', 58, 31.670000000000002, 10.33, 300);
INSERT INTO exposed VALUES ('11899442_2800782_20120912', 35.329999999999998, 35.329999999999998, 29.329999999999998, 300);
INSERT INTO exposed VALUES ('11923621_2758937_20120912', 53.329999999999998, 41.670000000000002, 5, 300);
INSERT INTO exposed VALUES ('11930446_2787645_20120912', 58, 24.670000000000002, 17.329999999999998, 300);
INSERT INTO exposed VALUES ('11931062_2787794_20120912', 65, 22.329999999999998, 12.67, 300);
INSERT INTO exposed VALUES ('11940135_2030387_20110826', 55, 28.329999999999998, 16.670000000000002, 300);
INSERT INTO exposed VALUES ('11971716_2010237_20110824', 42.670000000000002, 24.670000000000002, 32.670000000000002, 300);
INSERT INTO exposed VALUES ('11983110_2008149_20110824', 47.329999999999998, 27, 25.670000000000002, 300);
INSERT INTO exposed VALUES ('11999558_2004295_20110825', 46, 26, 28, 300);
INSERT INTO exposed VALUES ('12014414_2290349_20120924', 61.670000000000002, 38.329999999999998, 0, 300);
INSERT INTO exposed VALUES ('12018298_2297012_20120925', 61.329999999999998, 37.670000000000002, 1, 300);
INSERT INTO exposed VALUES ('12021868_2004097_20110825', 33.670000000000002, 37.329999999999998, 29, 300);
INSERT INTO exposed VALUES ('12023682_2293916_20120925', 78.329999999999998, 21.670000000000002, 0, 300);
INSERT INTO exposed VALUES ('12027448_2294176_20120925', 21.670000000000002, 66, 12.33, 300);
INSERT INTO exposed VALUES ('12033480_2298488_20120925', 63.670000000000002, 32, 4.3300000000000001, 300);
INSERT INTO exposed VALUES ('12045214_2307022_20120925', 50, 29.329999999999998, 20.670000000000002, 300);
INSERT INTO exposed VALUES ('12049020_2311419_20120925', 84.670000000000002, 15, 0.33000000000000002, 300);
INSERT INTO exposed VALUES ('12051799_2876268_20121121', 61, 27, 12, 300);
INSERT INTO exposed VALUES ('12060963_2748970_20120913', 72, 26.329999999999998, 1.6699999999999999, 300);
INSERT INTO exposed VALUES ('12073715_2830642_20121121', 71.329999999999998, 23.670000000000002, 5, 300);
INSERT INTO exposed VALUES ('12078856_2670024_20120913', 55.670000000000002, 38, 6.3300000000000001, 300);
INSERT INTO exposed VALUES ('12081695_2870840_20121121', 59, 39.670000000000002, 1.3300000000000001, 300);
INSERT INTO exposed VALUES ('12086310_2869975_20121121', 48.670000000000002, 37, 14.33, 300);
INSERT INTO exposed VALUES ('12086808_2668752_20120913', 39.329999999999998, 32.670000000000002, 28, 300);
INSERT INTO exposed VALUES ('12086830_2668917_20120913', 54.329999999999998, 31, 14.67, 300);
INSERT INTO exposed VALUES ('12087176_1982261_20110825', 55.329999999999998, 21.670000000000002, 23, 300);
INSERT INTO exposed VALUES ('12098398_1980546_20110825', 66, 19.670000000000002, 14.33, 300);
INSERT INTO exposed VALUES ('12111276_3059744_20110531', 58.329999999999998, 19.329999999999998, 22.329999999999998, 300);
INSERT INTO exposed VALUES ('12132141_3079041_20110530', 48.670000000000002, 39, 12.33, 300);
INSERT INTO exposed VALUES ('12172062_3086876_20101013', 75, 22, 3, 300);
INSERT INTO exposed VALUES ('12172400_3012990_20110523', 92.670000000000002, 5.6699999999999999, 1.6699999999999999, 300);
INSERT INTO exposed VALUES ('12172440_3086897_20101013', 72.329999999999998, 16.670000000000002, 11, 300);
INSERT INTO exposed VALUES ('12174961_3086131_20101012', 54.329999999999998, 33.329999999999998, 12.33, 300);
INSERT INTO exposed VALUES ('12177021_2889261_20121120', 53.670000000000002, 44.670000000000002, 1.6699999999999999, 300);
INSERT INTO exposed VALUES ('12180175_3013315_20110524', 83.670000000000002, 9.6699999999999999, 6.6699999999999999, 300);
INSERT INTO exposed VALUES ('12180993_2884538_20121120', 71.670000000000002, 23.670000000000002, 4.6699999999999999, 300);
INSERT INTO exposed VALUES ('12181548_2892350_20121120', 75.670000000000002, 18.670000000000002, 5.6699999999999999, 300);
INSERT INTO exposed VALUES ('12181644_2882923_20121120', 70, 25.670000000000002, 4.3300000000000001, 300);
INSERT INTO exposed VALUES ('12184843_3009103_20110524', 72, 21.670000000000002, 6.3300000000000001, 300);
INSERT INTO exposed VALUES ('12188617_3005526_20110524', 55, 35, 10, 300);
INSERT INTO exposed VALUES ('12191981_3088325_20101013', 70.329999999999998, 20.670000000000002, 9, 300);
INSERT INTO exposed VALUES ('12203391_3085276_20101013', 70.670000000000002, 21.329999999999998, 8, 300);
INSERT INTO exposed VALUES ('12203588_3085765_20101013', 83.670000000000002, 13, 3.3300000000000001, 300);
INSERT INTO exposed VALUES ('12279707_3203515_20120712', 39.329999999999998, 29.670000000000002, 31, 300);
INSERT INTO exposed VALUES ('12279982_3200454_20120712', 30.670000000000002, 28, 41.329999999999998, 300);
INSERT INTO exposed VALUES ('12289134_1777987_20120826', 9, 89.329999999999998, 1.6699999999999999, 300);
INSERT INTO exposed VALUES ('12293042_1777801_20120826', 18.670000000000002, 74, 7.3300000000000001, 300);
INSERT INTO exposed VALUES ('12293698_1774764_20120828', 22.670000000000002, 74.670000000000002, 2.6699999999999999, 300);
INSERT INTO exposed VALUES ('12339972_1766397_20120827', 19.329999999999998, 80.329999999999998, 0.33000000000000002, 300);
INSERT INTO exposed VALUES ('12340144_1766265_20120827', 43, 56.670000000000002, 0.33000000000000002, 300);
INSERT INTO exposed VALUES ('12344629_1764983_20120827', 61.329999999999998, 38.329999999999998, 0.33000000000000002, 300);
INSERT INTO exposed VALUES ('12345717_1766399_20120827', 9.6699999999999999, 90, 0.33000000000000002, 300);
INSERT INTO exposed VALUES ('12443605_1783850_20120829', 1, 89.670000000000002, 9.3300000000000001, 300);
INSERT INTO exposed VALUES ('12443608_1783627_20120829', 50.329999999999998, 37, 12.67, 300);
INSERT INTO exposed VALUES ('12446152_1800169_20120828', 56.670000000000002, 27.329999999999998, 16, 300);
INSERT INTO exposed VALUES ('12456286_1795113_20120828', 19, 77.329999999999998, 3.6699999999999999, 300);
INSERT INTO exposed VALUES ('12456729_1785321_20120828', 42.670000000000002, 52.670000000000002, 4.6699999999999999, 300);
INSERT INTO exposed VALUES ('12575462_1863982_20120830', 57.329999999999998, 36.670000000000002, 6, 300);
INSERT INTO exposed VALUES ('12580181_1832041_20120829', 36.329999999999998, 55.670000000000002, 8, 300);
INSERT INTO exposed VALUES ('12583406_1836437_20120829', 61.670000000000002, 33, 5.3300000000000001, 300);
INSERT INTO exposed VALUES ('12585131_1837465_20120829', 41.670000000000002, 53, 5.3300000000000001, 300);
INSERT INTO exposed VALUES ('12586176_3169803_20120711', 55, 38.329999999999998, 6.6699999999999999, 300);
INSERT INTO exposed VALUES ('12587551_3174618_20120711', 34, 40.670000000000002, 25.329999999999998, 300);
INSERT INTO exposed VALUES ('12607137_1863731_20120830', 60, 34.670000000000002, 5.3300000000000001, 300);
INSERT INTO exposed VALUES ('12612298_3196658_20120711', 31, 66, 3, 300);
INSERT INTO exposed VALUES ('12612335_3196219_20120711', 71, 20.670000000000002, 8.3300000000000001, 300);
INSERT INTO exposed VALUES ('12613472_3115336_20120711', 41, 32, 27, 300);
INSERT INTO exposed VALUES ('12704119_3198328_20120710', 21.670000000000002, 58, 20.329999999999998, 300);
INSERT INTO exposed VALUES ('12707605_3188993_20120710', 21.329999999999998, 41.670000000000002, 37, 300);
INSERT INTO exposed VALUES ('12711100_3198175_20120710', 22.329999999999998, 49.670000000000002, 28, 300);
INSERT INTO exposed VALUES ('12720587_1855271_20110714', 67.329999999999998, 32.670000000000002, 0, 300);
INSERT INTO exposed VALUES ('12731069_1845937_20110715', 47.329999999999998, 18, 34.670000000000002, 300);
INSERT INTO exposed VALUES ('12737191_1845416_20110714', 52.329999999999998, 25, 22.670000000000002, 300);
INSERT INTO exposed VALUES ('12762802_1760678_20110921', 61.329999999999998, 36, 2.6699999999999999, 300);
INSERT INTO exposed VALUES ('12766501_1761065_20110920', 31.329999999999998, 61.670000000000002, 7, 300);
INSERT INTO exposed VALUES ('12784557_3186831_20120710', 47.670000000000002, 49.670000000000002, 2.6699999999999999, 300);
INSERT INTO exposed VALUES ('12785265_3186366_20120710', 32.329999999999998, 47.670000000000002, 20, 300);
INSERT INTO exposed VALUES ('12790622_3180517_20120709', 27.329999999999998, 72, 0.67000000000000004, 300);
INSERT INTO exposed VALUES ('12792064_3173213_20120709', 44.670000000000002, 29, 26.329999999999998, 300);
INSERT INTO exposed VALUES ('12792148_3170800_20120709', 33.670000000000002, 47.670000000000002, 18.670000000000002, 300);
INSERT INTO exposed VALUES ('12803422_1740389_20110715', 37.329999999999998, 54.329999999999998, 8.3300000000000001, 300);
INSERT INTO exposed VALUES ('12817997_1713102_20110920', 67.670000000000002, 31.670000000000002, 0.67000000000000004, 300);
INSERT INTO exposed VALUES ('12822574_1703609_20110921', 39.329999999999998, 59, 1.6699999999999999, 300);
INSERT INTO exposed VALUES ('12838338_1559299_20110712', 33.670000000000002, 48, 18.329999999999998, 300);
INSERT INTO exposed VALUES ('12855716_1553530_20110713', 23.670000000000002, 67, 9.3300000000000001, 300);
INSERT INTO exposed VALUES ('12873726_1556192_20110711', 88.5, 8, 3.5, 200);
INSERT INTO exposed VALUES ('12890334_1545220_20110711', 21.329999999999998, 73.329999999999998, 5.3300000000000001, 300);
INSERT INTO exposed VALUES ('13046504_3146915_20121129', 49, 49, 2, 300);
INSERT INTO exposed VALUES ('13048469_3132132_20121130', 49.670000000000002, 48, 2.3300000000000001, 300);
INSERT INTO exposed VALUES ('13062907_3109014_20121130', 51, 40.329999999999998, 8.6699999999999999, 300);
INSERT INTO exposed VALUES ('13064460_3126275_20121130', 35.329999999999998, 64.670000000000002, 0, 300);
INSERT INTO exposed VALUES ('13065322_1831198_20120724', 46, 31.670000000000002, 22.329999999999998, 300);
INSERT INTO exposed VALUES ('13067930_1823425_20120724', 33.670000000000002, 49.329999999999998, 17, 300);
INSERT INTO exposed VALUES ('13071426_3058153_20121201', 51.329999999999998, 43.329999999999998, 5.3300000000000001, 300);
INSERT INTO exposed VALUES ('13074140_1318526_20110524', 52.329999999999998, 35, 12.67, 300);
INSERT INTO exposed VALUES ('13075335_1786985_20120725', 19.329999999999998, 72.329999999999998, 8.3300000000000001, 300);
INSERT INTO exposed VALUES ('13075897_1803569_20120724', 49.670000000000002, 34.329999999999998, 16, 300);
INSERT INTO exposed VALUES ('13076839_1801991_20120724', 54, 28, 18, 300);
INSERT INTO exposed VALUES ('13079408_1780441_20120725', 18.670000000000002, 79.670000000000002, 1.6699999999999999, 300);
INSERT INTO exposed VALUES ('13080208_3021619_20121202', 44.329999999999998, 54.329999999999998, 1.3300000000000001, 300);
INSERT INTO exposed VALUES ('13082756_1784949_20120725', 20.670000000000002, 78.329999999999998, 1, 300);
INSERT INTO exposed VALUES ('13085521_1773062_20120725', 54, 44.329999999999998, 1.6699999999999999, 300);
INSERT INTO exposed VALUES ('13086074_1305888_20110524', 1.6699999999999999, 73, 25.329999999999998, 300);
INSERT INTO exposed VALUES ('13086485_1780031_20120725', 50, 47, 3, 300);
INSERT INTO exposed VALUES ('13088244_1727422_20120727', 11.33, 87.329999999999998, 1.3300000000000001, 300);
INSERT INTO exposed VALUES ('13088519_3021486_20121202', 53, 45.670000000000002, 1.3300000000000001, 300);
INSERT INTO exposed VALUES ('13089864_3056072_20121201', 65, 30.670000000000002, 4.3300000000000001, 300);
INSERT INTO exposed VALUES ('13090381_1759149_20120726', 64.329999999999998, 32.670000000000002, 3, 300);
INSERT INTO exposed VALUES ('13090716_1747759_20120726', 43, 55.329999999999998, 1.6699999999999999, 300);
INSERT INTO exposed VALUES ('13091164_1715119_20120728', 6.6699999999999999, 92, 1.3300000000000001, 300);
INSERT INTO exposed VALUES ('13096893_3022836_20121202', 57, 42.670000000000002, 0.33000000000000002, 300);
INSERT INTO exposed VALUES ('13105614_1699375_20120729', 33.329999999999998, 65, 1.6699999999999999, 300);
INSERT INTO exposed VALUES ('13105852_2236138_20120726', 69, 11.33, 19.670000000000002, 300);
INSERT INTO exposed VALUES ('13106149_1666762_20120730', 48.329999999999998, 51.670000000000002, 0, 300);
INSERT INTO exposed VALUES ('13109410_1703746_20120728', 28.670000000000002, 69.670000000000002, 1.6699999999999999, 300);
INSERT INTO exposed VALUES ('13111593_1687703_20120729', 42, 57.670000000000002, 0.33000000000000002, 300);
INSERT INTO exposed VALUES ('13111938_2293410_20120727', 44.670000000000002, 46.670000000000002, 8.6699999999999999, 300);
INSERT INTO exposed VALUES ('13112321_1639183_20120731', 25.329999999999998, 73.329999999999998, 1.3300000000000001, 300);
INSERT INTO exposed VALUES ('13114604_1663973_20120730', 24.670000000000002, 75, 0.33000000000000002, 300);
INSERT INTO exposed VALUES ('13116095_1616052_20120801', 0.33000000000000002, 95.670000000000002, 4, 300);
INSERT INTO exposed VALUES ('13116592_1630492_20120801', 8.6699999999999999, 90, 1.3300000000000001, 300);
INSERT INTO exposed VALUES ('13116783_1654978_20120731', 18.329999999999998, 78.670000000000002, 3, 300);
INSERT INTO exposed VALUES ('13118243_1384658_20110523', 0, 31.670000000000002, 68.329999999999998, 300);
INSERT INTO exposed VALUES ('13118389_1621427_20120801', 3, 94.329999999999998, 2.6699999999999999, 300);
INSERT INTO exposed VALUES ('13118636_2281074_20120727', 57.670000000000002, 31, 11.33, 300);
INSERT INTO exposed VALUES ('13118884_1610273_20120802', 72.329999999999998, 27.329999999999998, 0.33000000000000002, 300);
INSERT INTO exposed VALUES ('13120958_1394520_20110523', 7.3300000000000001, 72.670000000000002, 20, 300);
INSERT INTO exposed VALUES ('13121769_1665107_20120730', 15.67, 84, 0.33000000000000002, 300);
INSERT INTO exposed VALUES ('13121833_1393432_20110523', 0, 74.329999999999998, 25.670000000000002, 300);
INSERT INTO exposed VALUES ('13123368_1608779_20120802', 39.329999999999998, 60.670000000000002, 0, 300);
INSERT INTO exposed VALUES ('13123893_1620861_20120801', 16, 84, 0, 300);
INSERT INTO exposed VALUES ('13162527_1411127_20120524', 0.33000000000000002, 41.329999999999998, 58.329999999999998, 300);
INSERT INTO exposed VALUES ('13257314_2362894_20120624', 44.670000000000002, 49, 6.3300000000000001, 300);
INSERT INTO exposed VALUES ('13267131_2367078_20120624', 25.329999999999998, 70.329999999999998, 4.3300000000000001, 300);
INSERT INTO exposed VALUES ('13268645_2314930_20120723', 23, 62, 15, 300);
INSERT INTO exposed VALUES ('13271541_2454551_20110826', 23.670000000000002, 60.670000000000002, 15.67, 300);
INSERT INTO exposed VALUES ('13272083_2443896_20110826', 29.329999999999998, 50.329999999999998, 20.329999999999998, 300);
INSERT INTO exposed VALUES ('13275115_2439523_20110826', 36.670000000000002, 46.329999999999998, 17, 300);
INSERT INTO exposed VALUES ('13277198_2458019_20110826', 19, 69.670000000000002, 11.33, 300);
INSERT INTO exposed VALUES ('13277838_2454760_20110826', 36, 59.670000000000002, 4.3300000000000001, 300);
INSERT INTO exposed VALUES ('13278179_2262331_20120724', 56, 33, 11, 300);
INSERT INTO exposed VALUES ('13278427_2244051_20120725', 61, 20.670000000000002, 18.329999999999998, 300);
INSERT INTO exposed VALUES ('13279739_2282429_20120724', 3.3300000000000001, 69.329999999999998, 27.329999999999998, 300);
INSERT INTO exposed VALUES ('13293328_2459681_20110825', 52.329999999999998, 41.670000000000002, 6, 300);
INSERT INTO exposed VALUES ('13307507_2458592_20110825', 32.670000000000002, 59, 8.3300000000000001, 300);
INSERT INTO exposed VALUES ('13312350_2464994_20110825', 24.670000000000002, 69.670000000000002, 5.6699999999999999, 300);
INSERT INTO exposed VALUES ('13317543_2467970_20110825', 48, 35.670000000000002, 16.329999999999998, 300);
INSERT INTO exposed VALUES ('13327333_2465087_20110824', 50, 42.670000000000002, 7.3300000000000001, 300);
INSERT INTO exposed VALUES ('13332080_2448020_20110827', 45.670000000000002, 41, 13.33, 300);
INSERT INTO exposed VALUES ('13341372_2459632_20110822', 61.670000000000002, 32.329999999999998, 6, 300);
INSERT INTO exposed VALUES ('13350501_2453706_20110823', 45.670000000000002, 42.329999999999998, 12, 300);
INSERT INTO exposed VALUES ('13351893_2460906_20110823', 52.670000000000002, 39.670000000000002, 7.6699999999999999, 300);
INSERT INTO exposed VALUES ('13353299_2471530_20110823', 54.329999999999998, 41, 4.6699999999999999, 300);
INSERT INTO exposed VALUES ('13364209_2781395_20110414', 54, 23.670000000000002, 22.329999999999998, 300);
INSERT INTO exposed VALUES ('13365488_2434204_20120305', 43.329999999999998, 38, 18.670000000000002, 300);
INSERT INTO exposed VALUES ('13389124_2377708_20120627', 35.670000000000002, 62, 2.3300000000000001, 300);
INSERT INTO exposed VALUES ('13396357_2375483_20120806', 56, 36.670000000000002, 7.3300000000000001, 300);
INSERT INTO exposed VALUES ('13403275_2735735_20110413', 42.670000000000002, 42.329999999999998, 15, 300);
INSERT INTO exposed VALUES ('13411564_2791806_20110414', 63.329999999999998, 25, 11.67, 300);
INSERT INTO exposed VALUES ('13426837_2887273_20110416', 50.329999999999998, 14.33, 35.329999999999998, 300);
INSERT INTO exposed VALUES ('13432984_2862788_20110416', 65.670000000000002, 14.33, 20, 300);
INSERT INTO exposed VALUES ('13433160_1894193_20110803', 2, 71.670000000000002, 26.329999999999998, 300);
INSERT INTO exposed VALUES ('13438505_2706742_20110412', 22.329999999999998, 41, 36.670000000000002, 300);
INSERT INTO exposed VALUES ('13442519_2711861_20110413', 24.670000000000002, 41.329999999999998, 34, 300);
INSERT INTO exposed VALUES ('13443257_2897730_20110416', 77.329999999999998, 10.33, 12.33, 300);
INSERT INTO exposed VALUES ('13443712_2715648_20110413', 61.670000000000002, 28, 10.33, 300);
INSERT INTO exposed VALUES ('13446469_2710988_20110412', 24, 37, 39, 300);
INSERT INTO exposed VALUES ('13454553_1878901_20110802', 31.329999999999998, 53.670000000000002, 15, 300);
INSERT INTO exposed VALUES ('13458257_1884783_20110803', 24.329999999999998, 58.670000000000002, 17, 300);
INSERT INTO exposed VALUES ('13461343_2708581_20110412', 28, 50.670000000000002, 21.329999999999998, 300);
INSERT INTO exposed VALUES ('13468896_2791339_20110415', 68.670000000000002, 19.670000000000002, 11.67, 300);
INSERT INTO exposed VALUES ('13481773_2821166_20110415', 36, 56.5, 7.5, 200);
INSERT INTO exposed VALUES ('13483416_2809061_20110415', 44.329999999999998, 24, 31.670000000000002, 300);
INSERT INTO exposed VALUES ('13498110_2593378_20120814', 47.670000000000002, 34.329999999999998, 18, 300);
INSERT INTO exposed VALUES ('13504069_1800176_20111025', 17.670000000000002, 79.670000000000002, 2.6699999999999999, 300);
INSERT INTO exposed VALUES ('13513683_2597453_20120814', 63.329999999999998, 25.670000000000002, 11, 300);
INSERT INTO exposed VALUES ('13523319_2557870_20120815', 87.670000000000002, 11.33, 1, 300);
INSERT INTO exposed VALUES ('13525977_1805696_20111026', 26.329999999999998, 72.329999999999998, 1.3300000000000001, 300);
INSERT INTO exposed VALUES ('13526981_1832964_20120626', 9.3300000000000001, 86, 4.6699999999999999, 300);
INSERT INTO exposed VALUES ('13534219_2538810_20120815', 69, 27.329999999999998, 3.6699999999999999, 300);
INSERT INTO exposed VALUES ('13535229_2479379_20120817', 59, 29, 12, 300);
INSERT INTO exposed VALUES ('13535947_2516711_20120816', 66.329999999999998, 31, 2.6699999999999999, 300);
INSERT INTO exposed VALUES ('13537890_2490989_20120817', 25, 72.670000000000002, 2.3300000000000001, 300);
INSERT INTO exposed VALUES ('13538347_2522634_20120816', 73, 17.329999999999998, 9.6699999999999999, 300);
INSERT INTO exposed VALUES ('13539959_2512532_20120816', 49.329999999999998, 50, 0.67000000000000004, 300);
INSERT INTO exposed VALUES ('13545889_3093625_20121203', 56, 38.670000000000002, 5.3300000000000001, 300);
INSERT INTO exposed VALUES ('13546833_3047058_20121205', 35, 64.329999999999998, 0.67000000000000004, 300);
INSERT INTO exposed VALUES ('13549101_3029011_20121204', 69, 22.670000000000002, 8.3300000000000001, 300);
INSERT INTO exposed VALUES ('13558052_3019600_20121204', 68.670000000000002, 30.329999999999998, 1, 300);
INSERT INTO exposed VALUES ('13560813_3006980_20121205', 80, 19.670000000000002, 0.33000000000000002, 300);
INSERT INTO exposed VALUES ('13562136_2339629_20120822', 2.3300000000000001, 91.329999999999998, 6.3300000000000001, 300);
INSERT INTO exposed VALUES ('13565527_2326070_20120821', 37, 55.670000000000002, 7.3300000000000001, 300);
INSERT INTO exposed VALUES ('13577134_2324359_20120822', 55, 26, 19, 300);
INSERT INTO exposed VALUES ('13580538_2333654_20120822', 52.329999999999998, 36, 11.67, 300);
INSERT INTO exposed VALUES ('13584964_2854138_20120411', 66, 17.670000000000002, 16.329999999999998, 300);
INSERT INTO exposed VALUES ('13601547_2821178_20120412', 80, 9.6699999999999999, 10.33, 300);
INSERT INTO exposed VALUES ('13604655_2873414_20120427', 82.329999999999998, 15.33, 2.3300000000000001, 300);
INSERT INTO exposed VALUES ('13611844_2794450_20120413', 90, 6, 4, 300);
INSERT INTO exposed VALUES ('13613586_2881878_20120411', 77.670000000000002, 17.329999999999998, 5, 300);
INSERT INTO exposed VALUES ('13614445_2832975_20120412', 84.670000000000002, 9, 6.3300000000000001, 300);
INSERT INTO exposed VALUES ('13616937_3366874_20121211', 12.5, 87.5, 0, 200);
INSERT INTO exposed VALUES ('13619058_3349897_20121212', 18, 82, 0, 200);
INSERT INTO exposed VALUES ('13622174_2720159_20120415', 63.670000000000002, 19.329999999999998, 17, 300);
INSERT INTO exposed VALUES ('13626237_3302276_20121214', 26, 73.5, 0.5, 200);
INSERT INTO exposed VALUES ('13626357_3381195_20121130', 17.5, 82.5, 0, 200);
INSERT INTO exposed VALUES ('13627571_2798015_20120413', 95.670000000000002, 1.3300000000000001, 3, 300);
INSERT INTO exposed VALUES ('13630686_2710211_20120414', 47.670000000000002, 19.670000000000002, 32.670000000000002, 300);
INSERT INTO exposed VALUES ('13635124_2721688_20120415', 90.329999999999998, 3.6699999999999999, 6, 300);
INSERT INTO exposed VALUES ('13641637_2716168_20120414', 44, 47, 9, 300);
INSERT INTO exposed VALUES ('13642088_3296975_20121214', 57.5, 42, 0.5, 200);
INSERT INTO exposed VALUES ('13665755_3173388_20120429', 54.329999999999998, 24.329999999999998, 21.329999999999998, 300);
INSERT INTO exposed VALUES ('13671030_3180414_20120428', 62.670000000000002, 25.670000000000002, 11.67, 300);
INSERT INTO exposed VALUES ('13678426_1673963_20110913', 40.329999999999998, 51.670000000000002, 8, 300);
INSERT INTO exposed VALUES ('13679866_3180298_20120428', 55.329999999999998, 29.670000000000002, 15, 300);
INSERT INTO exposed VALUES ('13682086_3177630_20120428', 74, 12, 14, 300);
INSERT INTO exposed VALUES ('13688221_1675267_20110914', 20, 65.670000000000002, 14.33, 300);
INSERT INTO exposed VALUES ('13695772_3027969_20120418', 81.329999999999998, 10.67, 8, 300);
INSERT INTO exposed VALUES ('13702137_1616362_20110916', 35, 51, 14, 300);
INSERT INTO exposed VALUES ('13709343_2982266_20120417', 84.329999999999998, 9.3300000000000001, 6.3300000000000001, 300);
INSERT INTO exposed VALUES ('13718529_2964572_20120417', 81.670000000000002, 9, 9.3300000000000001, 300);
INSERT INTO exposed VALUES ('13720792_2971988_20120417', 78.329999999999998, 10.33, 11.33, 300);
INSERT INTO exposed VALUES ('13721680_2983529_20120418', 55.670000000000002, 35.670000000000002, 8.6699999999999999, 300);
INSERT INTO exposed VALUES ('13731493_1832955_20110918', 41, 41.670000000000002, 17.329999999999998, 300);
INSERT INTO exposed VALUES ('13743948_1839666_20110921', 22.329999999999998, 71.329999999999998, 6.3300000000000001, 300);
INSERT INTO exposed VALUES ('13744988_1820680_20110922', 34.329999999999998, 47.670000000000002, 18, 300);
INSERT INTO exposed VALUES ('13746366_1798531_20110922', 56.670000000000002, 36.670000000000002, 6.6699999999999999, 300);
INSERT INTO exposed VALUES ('13746582_1841697_20110919', 13.33, 64.670000000000002, 22, 300);
INSERT INTO exposed VALUES ('13747622_1831003_20110922', 46, 40, 14, 300);
INSERT INTO exposed VALUES ('13748031_1793256_20110923', 31.670000000000002, 54.329999999999998, 14, 300);
INSERT INTO exposed VALUES ('13749145_1847931_20110920', 58, 30, 12, 300);
INSERT INTO exposed VALUES ('13749216_1844751_20110921', 43, 45.670000000000002, 11.33, 300);
INSERT INTO exposed VALUES ('13756502_1850887_20110919', 52.329999999999998, 29.329999999999998, 18.329999999999998, 300);
INSERT INTO exposed VALUES ('13757232_1851860_20110920', 48, 45.329999999999998, 6.6699999999999999, 300);
INSERT INTO exposed VALUES ('13760825_2910145_20110510', 54, 36, 10, 300);
INSERT INTO exposed VALUES ('13766973_2964108_20110511', 78, 13.67, 8.3300000000000001, 300);
INSERT INTO exposed VALUES ('13772064_1778625_20110929', 29.329999999999998, 62.670000000000002, 8, 300);
INSERT INTO exposed VALUES ('13778441_1777403_20110930', 31, 61.670000000000002, 7.3300000000000001, 300);
INSERT INTO exposed VALUES ('13792896_2929167_20110511', 73.670000000000002, 22.329999999999998, 4, 300);
INSERT INTO exposed VALUES ('13804424_3195084_20121206', 68.670000000000002, 27.329999999999998, 4, 300);
INSERT INTO exposed VALUES ('13805320_2901893_20110508', 40.329999999999998, 42.670000000000002, 17, 300);
INSERT INTO exposed VALUES ('13814264_2881094_20110507', 52.670000000000002, 29.670000000000002, 17.670000000000002, 300);
INSERT INTO exposed VALUES ('13814431_2862125_20110507', 25, 57, 18, 300);
INSERT INTO exposed VALUES ('13815283_2954151_20110511', 81.670000000000002, 15.33, 3, 300);
INSERT INTO exposed VALUES ('13819621_3165724_20121206', 77, 22.329999999999998, 0.67000000000000004, 300);
INSERT INTO exposed VALUES ('13821123_2914338_20110510', 37, 47.329999999999998, 15.67, 300);
INSERT INTO exposed VALUES ('13823818_3086124_20110512', 75.670000000000002, 13, 11.33, 300);
INSERT INTO exposed VALUES ('13824918_2916939_20110509', 43.670000000000002, 41, 15.33, 300);
INSERT INTO exposed VALUES ('13833401_3020059_20110512', 78.670000000000002, 14.33, 7, 300);
INSERT INTO exposed VALUES ('13834428_2933265_20110510', 65.670000000000002, 25.670000000000002, 8.6699999999999999, 300);
INSERT INTO exposed VALUES ('13837964_3113496_20121207', 69, 29.329999999999998, 1.6699999999999999, 300);
INSERT INTO exposed VALUES ('13838695_3097778_20120427', 79, 9.3300000000000001, 11.67, 300);
INSERT INTO exposed VALUES ('13841900_2883300_20110507', 47.329999999999998, 43, 9.6699999999999999, 300);
INSERT INTO exposed VALUES ('13850475_2873699_20110506', 40.670000000000002, 30.329999999999998, 29, 300);
INSERT INTO exposed VALUES ('13853758_2882605_20110509', 87, 9.3300000000000001, 3.6699999999999999, 300);
INSERT INTO exposed VALUES ('13862970_2836382_20110506', 94.329999999999998, 4.6699999999999999, 1, 300);
INSERT INTO exposed VALUES ('13866228_3002524_20120426', 63, 13.33, 23.670000000000002, 300);
INSERT INTO exposed VALUES ('13870624_2963661_20120425', 51.670000000000002, 16.329999999999998, 32, 300);
INSERT INTO exposed VALUES ('13873650_3011427_20120427', 51.670000000000002, 17, 31.329999999999998, 300);
INSERT INTO exposed VALUES ('13887142_2861061_20110509', 70, 26, 4, 300);
INSERT INTO exposed VALUES ('13891440_2854504_20110509', 25, 57.329999999999998, 17.670000000000002, 300);
INSERT INTO exposed VALUES ('13929235_3307257_20100728', 66.670000000000002, 22.329999999999998, 11, 300);
INSERT INTO exposed VALUES ('13943693_3317687_20100728', 84, 13, 3, 300);
INSERT INTO exposed VALUES ('13943905_3317231_20100728', 73, 18.670000000000002, 8.3300000000000001, 300);
INSERT INTO exposed VALUES ('13948505_3312038_20100728', 51.670000000000002, 37.670000000000002, 10.67, 300);
INSERT INTO exposed VALUES ('13960882_3181174_20120422', 62, 20.329999999999998, 17.670000000000002, 300);
INSERT INTO exposed VALUES ('13980407_3169145_20120423', 38.329999999999998, 40.329999999999998, 21.329999999999998, 300);
INSERT INTO exposed VALUES ('13980973_3140542_20120424', 62.329999999999998, 23.670000000000002, 14, 300);
INSERT INTO exposed VALUES ('13985756_3168929_20120424', 54.329999999999998, 25.670000000000002, 20, 300);
INSERT INTO exposed VALUES ('13991604_3138850_20120424', 31.670000000000002, 40, 28.329999999999998, 300);
INSERT INTO exposed VALUES ('13997501_3138928_20120424', 33.329999999999998, 45.670000000000002, 21, 300);
INSERT INTO exposed VALUES ('14118337_3188845_20110618', 26.670000000000002, 60, 13.33, 300);
INSERT INTO exposed VALUES ('14132738_3434739_20120118', 40, 55.5, 4.5, 200);
INSERT INTO exposed VALUES ('14149544_3526111_20120117', 28, 71.5, 0.5, 200);
INSERT INTO exposed VALUES ('14161659_3168445_20110618', 31.329999999999998, 26, 42.670000000000002, 300);
INSERT INTO exposed VALUES ('14162083_3167750_20110618', 57, 31.670000000000002, 11.33, 300);
INSERT INTO exposed VALUES ('14164246_3158482_20110618', 53, 27.670000000000002, 19.329999999999998, 300);
INSERT INTO exposed VALUES ('14169755_3436994_20120110', 70, 25.5, 4.5, 200);
INSERT INTO exposed VALUES ('14182175_3080688_20110617', 41.329999999999998, 43.670000000000002, 15, 300);
INSERT INTO exposed VALUES ('14191274_3525422_20120112', 29.5, 52, 18.5, 200);
INSERT INTO exposed VALUES ('14193934_3520777_20120111', 75.5, 24.5, 0, 200);
INSERT INTO exposed VALUES ('14196379_2952294_20110618', 59, 40, 1, 300);
INSERT INTO exposed VALUES ('14198519_3520873_20120111', 14, 84, 2, 200);
INSERT INTO exposed VALUES ('14199007_3051975_20110618', 58, 39.329999999999998, 2.6699999999999999, 300);
INSERT INTO exposed VALUES ('14200166_2988167_20110617', 49, 50, 1, 300);
INSERT INTO exposed VALUES ('14203142_2930024_20120420', 38.670000000000002, 40, 21.329999999999998, 300);
INSERT INTO exposed VALUES ('14203975_3574162_20120113', 25.5, 74.5, 0, 200);
INSERT INTO exposed VALUES ('14226325_2940050_20120420', 55, 32.670000000000002, 12.33, 300);
INSERT INTO exposed VALUES ('14232537_3242925_20110419', 45.670000000000002, 18.329999999999998, 36, 300);
INSERT INTO exposed VALUES ('14241555_3507037_20120116', 22, 75.5, 2.5, 200);
INSERT INTO exposed VALUES ('14241635_3046537_20110617', 55.329999999999998, 39.329999999999998, 5.3300000000000001, 300);
INSERT INTO exposed VALUES ('14248057_3546270_20120119', 22.5, 74, 3.5, 200);
INSERT INTO exposed VALUES ('14255021_3556313_20120119', 63.5, 36.5, 0, 200);
INSERT INTO exposed VALUES ('14258446_3505184_20120116', 49, 41, 10, 200);
INSERT INTO exposed VALUES ('14271416_3008028_20110617', 36.670000000000002, 54.329999999999998, 9, 300);
INSERT INTO exposed VALUES ('14286732_1813808_20110717', 18.670000000000002, 75.670000000000002, 5.6699999999999999, 300);
INSERT INTO exposed VALUES ('14294295_3548648_20120124', 28, 71, 1, 200);
INSERT INTO exposed VALUES ('14301561_3548041_20120124', 34, 64.5, 1.5, 200);
INSERT INTO exposed VALUES ('14312736_3571455_20120124', 6, 86, 8, 200);
INSERT INTO exposed VALUES ('14330707_3164497_20110619', 16.329999999999998, 80.670000000000002, 3, 300);
INSERT INTO exposed VALUES ('14334588_3539619_20120123', 57, 41.5, 1.5, 200);
INSERT INTO exposed VALUES ('14337535_1826233_20110717', 11.67, 83, 5.3300000000000001, 300);
INSERT INTO exposed VALUES ('14348111_3150750_20110619', 20, 53.329999999999998, 26.670000000000002, 300);
INSERT INTO exposed VALUES ('14351578_3103787_20110615', 6, 87.670000000000002, 6.3300000000000001, 300);
INSERT INTO exposed VALUES ('14363092_3150399_20110619', 22.670000000000002, 74.329999999999998, 3, 300);
INSERT INTO exposed VALUES ('14381027_3146251_20110619', 11.67, 23, 65.329999999999998, 300);
INSERT INTO exposed VALUES ('14386819_3689426_20110329', 5, 95, 0, 200);
INSERT INTO exposed VALUES ('14395057_3682014_20110328', 29.5, 69, 1.5, 200);
INSERT INTO exposed VALUES ('14396555_3683674_20110328', 25.670000000000002, 29, 45.329999999999998, 300);
INSERT INTO exposed VALUES ('14396569_3684166_20120217', 36, 62, 2, 200);
INSERT INTO exposed VALUES ('14397763_3682692_20120217', 15, 84.5, 0.5, 200);
INSERT INTO exposed VALUES ('14398453_3674622_20120215', 36.5, 63.5, 0, 200);
INSERT INTO exposed VALUES ('14400495_3675850_20120216', 1, 99, 0, 300);
INSERT INTO exposed VALUES ('14401439_3676045_20110329', 3.3300000000000001, 39.670000000000002, 57, 300);
INSERT INTO exposed VALUES ('14401452_3676050_20120216', 9.6699999999999999, 88.670000000000002, 1.6699999999999999, 300);
INSERT INTO exposed VALUES ('14406589_3682695_20110329', 9.6699999999999999, 60, 30.329999999999998, 300);
INSERT INTO exposed VALUES ('14413189_3645925_20120201', 81.670000000000002, 16, 2.3300000000000001, 300);
INSERT INTO exposed VALUES ('14473092_3086263_20121017', 7.6699999999999999, 46.329999999999998, 46, 300);
INSERT INTO exposed VALUES ('14481858_3068761_20121017', 3.6699999999999999, 92.670000000000002, 3.6699999999999999, 300);
INSERT INTO exposed VALUES ('14483695_3458925_20120821', 3.3300000000000001, 79, 17.670000000000002, 300);
INSERT INTO exposed VALUES ('14493319_3067220_20121017', 2.6699999999999999, 95, 2.3300000000000001, 300);
INSERT INTO exposed VALUES ('14496822_2151829_20120421', 29.670000000000002, 45.329999999999998, 25, 300);
INSERT INTO exposed VALUES ('14510894_3057308_20121017', 32, 64.670000000000002, 3.3300000000000001, 300);
INSERT INTO exposed VALUES ('14515962_2214581_20120421', 19, 27.329999999999998, 53.670000000000002, 300);
INSERT INTO exposed VALUES ('14521058_3001795_20121017', 25.670000000000002, 74.329999999999998, 0, 300);
INSERT INTO exposed VALUES ('14522240_3466812_20120822', 8, 65.670000000000002, 26.329999999999998, 300);
INSERT INTO exposed VALUES ('14523304_3469905_20120822', 50.329999999999998, 23, 26.670000000000002, 300);
INSERT INTO exposed VALUES ('14524143_3466177_20120822', 34, 48.670000000000002, 17.329999999999998, 300);
INSERT INTO exposed VALUES ('14528605_3411825_20120821', 8, 76, 16, 300);
INSERT INTO exposed VALUES ('14544102_3398705_20120821', 6, 67.329999999999998, 26.670000000000002, 300);
INSERT INTO exposed VALUES ('14545150_3354999_20120820', 1.3300000000000001, 51.329999999999998, 47.329999999999998, 300);
INSERT INTO exposed VALUES ('14560277_2002303_20121021', 42, 34.670000000000002, 23.329999999999998, 300);
INSERT INTO exposed VALUES ('14562242_2000473_20121021', 15.33, 47, 37.670000000000002, 300);
INSERT INTO exposed VALUES ('14564897_1997958_20121021', 19, 51.670000000000002, 29.329999999999998, 300);
INSERT INTO exposed VALUES ('14567068_1950304_20120513', 1.6699999999999999, 19.670000000000002, 78.670000000000002, 300);
INSERT INTO exposed VALUES ('14571844_1948253_20121018', 4.3300000000000001, 74.670000000000002, 21, 300);
INSERT INTO exposed VALUES ('14573653_1947261_20111104', 0, 76.670000000000002, 23.329999999999998, 300);
INSERT INTO exposed VALUES ('14573656_1947259_20121018', 5.3300000000000001, 67, 27.670000000000002, 300);
INSERT INTO exposed VALUES ('14581522_1935213_20121018', 23.329999999999998, 69, 7.6699999999999999, 300);
INSERT INTO exposed VALUES ('14582053_1937830_20121017', 4.6699999999999999, 78.329999999999998, 17, 300);
INSERT INTO exposed VALUES ('14582381_1965758_20121023', 9.6699999999999999, 76, 14.33, 300);
INSERT INTO exposed VALUES ('14617986_4155849_20121217', 65, 28, 7, 200);
INSERT INTO exposed VALUES ('14639016_2986037_20121016', 35.670000000000002, 60, 4.3300000000000001, 300);
INSERT INTO exposed VALUES ('14648163_2978138_20121016', 51, 46.670000000000002, 2.3300000000000001, 300);
INSERT INTO exposed VALUES ('14651111_2964476_20121016', 1.6699999999999999, 94, 4.3300000000000001, 300);
INSERT INTO exposed VALUES ('14653967_4159704_20121212', 46, 6, 48, 200);
INSERT INTO exposed VALUES ('14655115_4160323_20121212', 88.5, 5, 6.5, 200);
INSERT INTO exposed VALUES ('14655499_4160343_20121212', 1, 16.329999999999998, 82.670000000000002, 300);
INSERT INTO exposed VALUES ('14655614_4161569_20121212', 88, 11, 1, 200);
INSERT INTO exposed VALUES ('14656801_2973987_20121016', 14, 76, 10, 300);
INSERT INTO exposed VALUES ('14658220_4139744_20120614', 0.33000000000000002, 53.670000000000002, 46, 300);
INSERT INTO exposed VALUES ('14660805_2967386_20121016', 7.3300000000000001, 86.329999999999998, 6.3300000000000001, 300);
INSERT INTO exposed VALUES ('14664359_2967353_20121016', 28.329999999999998, 69.329999999999998, 2.3300000000000001, 300);
INSERT INTO exposed VALUES ('14669802_4154172_20121212', 64.5, 4, 31.5, 200);
INSERT INTO exposed VALUES ('14677006_4152277_20120614', 1, 47.670000000000002, 51.329999999999998, 300);
INSERT INTO exposed VALUES ('14688938_4150879_20121217', 32.5, 4.5, 63, 200);
INSERT INTO exposed VALUES ('14702740_1938591_20110711', 21, 10, 69, 300);
INSERT INTO exposed VALUES ('14705471_2641128_20110618', 8.6699999999999999, 80.670000000000002, 10.67, 300);
INSERT INTO exposed VALUES ('14721622_1945671_20110711', 12.33, 22, 65.670000000000002, 300);
INSERT INTO exposed VALUES ('14725188_4163165_20130218', 3, 1, 96, 300);
INSERT INTO exposed VALUES ('14731710_4211952_20121211', 3, 92.329999999999998, 4.6699999999999999, 300);
INSERT INTO exposed VALUES ('14733122_4209721_20110401', 4.3300000000000001, 48.670000000000002, 47, 300);
INSERT INTO exposed VALUES ('14735648_4217453_20120621', 38, 15.33, 46.670000000000002, 300);
INSERT INTO exposed VALUES ('14736004_4210405_20110401', 47.5, 41.5, 11, 200);
INSERT INTO exposed VALUES ('14736057_4209033_20121211', 7, 48.5, 44.5, 200);
INSERT INTO exposed VALUES ('14738675_4219476_20120621', 41.329999999999998, 37, 21.670000000000002, 300);
INSERT INTO exposed VALUES ('14741491_4221687_20120621', 12, 6.6699999999999999, 81.329999999999998, 300);
INSERT INTO exposed VALUES ('14742385_4229192_20120628', 80, 14, 6, 300);
INSERT INTO exposed VALUES ('14744226_4226603_20120628', 57.5, 21, 21.5, 200);
INSERT INTO exposed VALUES ('14744528_4228802_20120628', 43, 23.5, 33.5, 200);
INSERT INTO exposed VALUES ('14744873_4217967_20111207', 15.33, 40.329999999999998, 44.329999999999998, 300);
INSERT INTO exposed VALUES ('14745375_4215016_20121211', 9.5, 20.5, 70, 200);
INSERT INTO exposed VALUES ('14746432_4214433_20111207', 7, 87, 6, 300);
INSERT INTO exposed VALUES ('14756085_4204195_20110331', 0.33000000000000002, 78.670000000000002, 21, 300);
INSERT INTO exposed VALUES ('14756253_4203818_20110331', 3.6699999999999999, 52.670000000000002, 43.670000000000002, 300);
INSERT INTO exposed VALUES ('14759071_3011140_20121018', 1.6699999999999999, 81, 17.329999999999998, 300);
INSERT INTO exposed VALUES ('14776692_2977754_20121019', 15.33, 82.329999999999998, 2.3300000000000001, 300);
INSERT INTO exposed VALUES ('14778102_3006257_20121018', 4.6699999999999999, 89, 6.3300000000000001, 300);
INSERT INTO exposed VALUES ('14780831_3035905_20121018', 8.3300000000000001, 81.670000000000002, 10, 300);
INSERT INTO exposed VALUES ('14790946_3017743_20121018', 4.3300000000000001, 74.670000000000002, 21, 300);
INSERT INTO exposed VALUES ('14791438_3186793_20110609', 0, 83.329999999999998, 16.670000000000002, 300);
INSERT INTO exposed VALUES ('14795143_2948202_20121019', 36.670000000000002, 53, 10.33, 300);
INSERT INTO exposed VALUES ('14802012_3010506_20121018', 8, 80.670000000000002, 11.33, 300);
INSERT INTO exposed VALUES ('14804097_2948135_20121019', 6, 81, 13, 300);
INSERT INTO exposed VALUES ('14812135_3028936_20121018', 2.3300000000000001, 85, 12.67, 300);
INSERT INTO exposed VALUES ('14845150_3214297_20101125', 9.6699999999999999, 48.670000000000002, 41.670000000000002, 300);
INSERT INTO exposed VALUES ('14885344_3205411_20101125', 3, 42, 55, 300);
INSERT INTO exposed VALUES ('14923445_3022458_20110726', 2, 71.329999999999998, 26.670000000000002, 300);
INSERT INTO exposed VALUES ('14969006_2968707_20110729', 1.3300000000000001, 92.670000000000002, 6, 300);
INSERT INTO exposed VALUES ('14978270_2934892_20121009', 12, 86.5, 1.5, 200);
INSERT INTO exposed VALUES ('14978973_2933962_20121009', 76, 24, 0, 200);
INSERT INTO exposed VALUES ('14979863_2934665_20121009', 76.5, 23, 0.5, 200);
INSERT INTO exposed VALUES ('14985754_2888700_20110727', 5, 94.329999999999998, 0.67000000000000004, 300);
INSERT INTO exposed VALUES ('14987909_2949814_20121009', 32.5, 48, 19.5, 200);
INSERT INTO exposed VALUES ('14988089_2950363_20121010', 7, 12, 81, 200);
INSERT INTO exposed VALUES ('14989649_2950450_20121010', 49, 34.5, 16.5, 200);
INSERT INTO exposed VALUES ('14990939_2885839_20110727', 0, 99, 1, 300);
INSERT INTO exposed VALUES ('15108622_2782483_20110921', 1.3300000000000001, 77, 21.670000000000002, 300);
INSERT INTO exposed VALUES ('15108825_2782464_20110921', 1, 78.670000000000002, 20.329999999999998, 300);
INSERT INTO exposed VALUES ('15108992_2782626_20110921', 2, 86.670000000000002, 11.33, 300);
INSERT INTO exposed VALUES ('15163989_2767940_20110921', 2, 74.670000000000002, 23.329999999999998, 300);
INSERT INTO exposed VALUES ('12597951_1879461_20120830', 19, 77.329999999999998, 3.6699999999999999, 300);
INSERT INTO exposed VALUES ('15122773_2556369_20110825', 6, 79.670000000000002, 14.33, 300);
INSERT INTO exposed VALUES ('15131609_2559558_20110825', 4.6699999999999999, 77, 18.329999999999998, 300);
INSERT INTO exposed VALUES ('14240703_3534033_20120118', 45, 55, 0, 200);
INSERT INTO exposed VALUES ('15031519_2819785_20110922', 23, 77, 0, 200);
INSERT INTO exposed VALUES ('15031731_2819803_20110922', 79.5, 20, 0.5, 200);
INSERT INTO exposed VALUES ('15029696_2818982_20110922', 24, 58, 18, 300);
INSERT INTO exposed VALUES ('15030045_2819081_20110922', 22, 78, 0, 200);
INSERT INTO exposed VALUES ('15026197_2818589_20110922', 25.329999999999998, 62.329999999999998, 12.33, 300);
INSERT INTO exposed VALUES ('14312736_3571454_20140120', 41.5, 58.5, 0, 200);
INSERT INTO exposed VALUES ('14294295_3548648_20140121', 15.5, 84.5, 0, 200);
INSERT INTO exposed VALUES ('14301037_3547556_20140121', 33.5, 66.5, 0, 200);
INSERT INTO exposed VALUES ('14301561_3548041_20140121', 46, 53.5, 0.5, 200);
INSERT INTO exposed VALUES ('14334588_3539618_20140121', 41.5, 58.5, 0, 200);
INSERT INTO exposed VALUES ('14336296_3539667_20140121', 40, 59, 1, 200);
INSERT INTO exposed VALUES ('14349215_3535442_20140122', 43, 57, 0, 200);
INSERT INTO exposed VALUES ('14241264_3533204_20140122', 35.5, 64.5, 0, 200);
INSERT INTO exposed VALUES ('14240703_3534033_20140122', 37.5, 62.5, 0, 200);
INSERT INTO exposed VALUES ('14242832_3534062_20140123', 30.5, 67, 2.5, 200);
INSERT INTO exposed VALUES ('14312722_3571484_20140424', 46.5, 52.5, 1, 200);
INSERT INTO exposed VALUES ('14294295_3548648_20140428', 27.5, 72.5, 0, 200);
INSERT INTO exposed VALUES ('14301038_3547556_20140430', 42, 55, 3, 200);
INSERT INTO exposed VALUES ('14240703_3534033_20140430', 51.5, 48, 0.5, 200);
INSERT INTO exposed VALUES ('14242933_3533946_20140501', 38, 54, 8, 200);
INSERT INTO exposed VALUES ('14241263_3533205_20140501', 42, 55, 3, 200);
INSERT INTO exposed VALUES ('14248058_3546270_20140501', 36.5, 63, 0.5, 200);
INSERT INTO exposed VALUES ('14194435_3521049_20140502', 39.329999999999998, 6.3300000000000001, 54.329999999999998, 300);
INSERT INTO exposed VALUES ('14072846_2802964_20140528', 62, 37, 1, 300);
INSERT INTO exposed VALUES ('14065798_2789775_20140529', 43.329999999999998, 52.329999999999998, 4.3300000000000001, 300);
INSERT INTO exposed VALUES ('14085998_2774286_20140529', 54.329999999999998, 44, 1.6699999999999999, 300);
INSERT INTO exposed VALUES ('14063400_2776085_20140529', 70.670000000000002, 28.670000000000002, 0.67000000000000004, 300);
INSERT INTO exposed VALUES ('14052192_2786356_20140529', 65.670000000000002, 34.329999999999998, 0, 300);
INSERT INTO exposed VALUES ('14045562_2743178_20140530', 49, 49, 2, 300);
INSERT INTO exposed VALUES ('14066367_2741258_20140530', 62.329999999999998, 36.670000000000002, 1, 300);
INSERT INTO exposed VALUES ('14067494_2736405_20140530', 45.670000000000002, 50, 4.3300000000000001, 300);
INSERT INTO exposed VALUES ('14067799_2721226_20140530', 39.670000000000002, 59.329999999999998, 1, 300);
INSERT INTO exposed VALUES ('11781903_2936208_20140623', 71.670000000000002, 8.6699999999999999, 19.670000000000002, 300);
INSERT INTO exposed VALUES ('11691800_2866486_20140624', 74, 11, 15, 300);
INSERT INTO exposed VALUES ('11694807_2860389_20140624', 69.329999999999998, 9.3300000000000001, 21.329999999999998, 300);
INSERT INTO exposed VALUES ('11674852_2842313_20140624', 76.329999999999998, 7.6699999999999999, 16, 300);
INSERT INTO exposed VALUES ('11674213_2841528_20140624', 85.329999999999998, 4.3300000000000001, 10.33, 300);
INSERT INTO exposed VALUES ('11623112_2795029_20140625', 69.329999999999998, 11.33, 19.329999999999998, 300);
INSERT INTO exposed VALUES ('11615541_2793974_20140625', 88.670000000000002, 5, 6.3300000000000001, 300);
INSERT INTO exposed VALUES ('11564707_2775026_20140625', 74.670000000000002, 11.67, 13.67, 300);
INSERT INTO exposed VALUES ('11560274_2775557_20140625', 74.329999999999998, 4, 21.670000000000002, 300);
INSERT INTO exposed VALUES ('13327909_1586980_20140527', 3, 65, 32, 300);
INSERT INTO exposed VALUES ('13331137_1577322_20140526', 13.67, 39, 47.329999999999998, 300);
INSERT INTO exposed VALUES ('13369494_1540160_20140520', 8, 51.670000000000002, 40.329999999999998, 300);
INSERT INTO exposed VALUES ('13347518_1544347_20140522', 2, 36.329999999999998, 61.670000000000002, 300);
INSERT INTO exposed VALUES ('13322012_1536750_20140522', 6.6699999999999999, 49, 44.329999999999998, 300);
INSERT INTO exposed VALUES ('13330517_1540039_20140523', 4.6699999999999999, 36.329999999999998, 59, 300);
INSERT INTO exposed VALUES ('13374662_1552581_20140524', 18.670000000000002, 42.670000000000002, 38.670000000000002, 300);
INSERT INTO exposed VALUES ('13355233_1557120_20140524', 18.329999999999998, 35.670000000000002, 46, 300);


--
-- Data for Name: fc_raw; Type: TABLE DATA; Schema: gcov_pub; Owner: gcov
--

INSERT INTO fc_raw VALUES (1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (201, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (202, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (203, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (204, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (205, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (206, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (207, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (208, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (209, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (210, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (211, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (212, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (213, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (214, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (215, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (216, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (217, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (218, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (219, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (220, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (221, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (222, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (223, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (224, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (225, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (226, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (227, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (228, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (229, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (230, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (231, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (232, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (233, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (234, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (235, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (236, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (237, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (238, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (239, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (240, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (241, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (242, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (243, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (244, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (245, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (246, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (247, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (248, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (249, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (250, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (251, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (252, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (253, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (254, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (255, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (256, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (257, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (258, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (259, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (260, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (261, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (262, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (263, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (264, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (265, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (266, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (267, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (268, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (269, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (270, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (271, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (272, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (273, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (274, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (275, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (276, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (277, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (278, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (279, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (280, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (281, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (282, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (283, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (284, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (285, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (286, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (287, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (288, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (289, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (290, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (291, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (292, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (293, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (294, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (295, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (296, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (297, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (298, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (299, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', NULL, NULL, NULL, NULL);
INSERT INTO fc_raw VALUES (300, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404294_2435553_20111018', NULL, NULL, NULL, NULL);
INSERT INTO fc_raw VALUES (1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (23, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (25, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (35, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (40, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (41, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (42, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (43, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (115, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, 1, 1, 3);
INSERT INTO fc_raw VALUES (142, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (165, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (166, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (197, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (198, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (199, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (200, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (201, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (202, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, 1, 1, 3);
INSERT INTO fc_raw VALUES (203, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (204, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (205, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (206, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (207, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (208, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (209, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (210, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (211, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (212, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (213, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (214, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (215, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (216, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (217, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (218, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (219, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (220, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (221, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (222, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (223, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (224, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (225, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (226, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (227, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (228, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (229, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (230, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (231, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (232, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (233, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (234, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (235, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (236, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (237, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (238, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (239, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (240, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (241, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (242, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (243, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (244, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (245, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (246, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (247, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (248, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (249, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (250, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (251, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (252, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (253, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (254, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (255, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (256, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (257, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (258, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (259, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (260, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (261, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (262, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (263, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (264, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (265, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (266, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (267, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (268, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (269, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (270, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (271, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (272, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (273, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (274, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (275, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (276, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (277, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (278, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (279, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (280, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (281, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (282, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (283, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (284, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11404614_2435705_20111018', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (285, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (286, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (287, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (288, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (289, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (290, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (291, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (292, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (293, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (294, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (295, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (296, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (297, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (298, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (299, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (300, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11404614_2435705_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (86, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, NULL, 1, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, NULL, 1, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (100, NULL, NULL, NULL, NULL, 1, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (101, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (192, NULL, NULL, NULL, NULL, 1, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (193, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (201, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (202, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (203, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (204, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (205, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (206, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (207, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (208, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (209, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (210, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (211, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (212, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (213, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (214, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (215, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (216, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (217, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (218, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (219, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (220, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (221, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (222, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (223, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (224, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (225, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (226, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (227, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (228, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (229, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (230, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (231, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (232, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (233, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (234, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (235, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (236, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (237, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (238, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (239, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (240, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (241, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (242, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (243, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (244, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (245, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (246, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (247, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (248, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (249, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (250, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (251, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (252, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (253, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (254, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (255, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (256, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (257, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (258, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (259, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (260, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (261, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (262, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (263, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (264, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (265, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (266, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (267, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (268, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (269, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (270, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (271, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (272, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (273, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (274, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (275, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (276, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (277, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (278, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (279, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (280, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (281, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (282, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (283, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (284, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (285, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (286, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (287, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (288, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (289, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (290, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (291, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (292, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (293, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (294, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (295, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (296, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (297, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (298, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (299, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (300, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11405667_2438212_20111018', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11423372_2557730_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (7, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (8, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11423372_2557730_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (12, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (21, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (96, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (166, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11423372_2557730_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (167, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (201, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (202, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (203, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (204, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (205, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (206, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (207, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (208, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (209, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (210, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (211, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (212, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (213, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (214, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (215, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (216, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (217, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (218, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (219, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (220, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (221, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (222, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (223, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (224, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (225, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (226, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (227, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (228, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (229, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (230, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (231, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (232, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (233, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (234, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (235, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (236, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (237, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (238, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (239, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (240, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (241, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (242, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (243, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (244, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (245, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (246, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (247, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (248, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (249, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (250, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (251, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (252, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (253, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (254, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (255, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (256, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (257, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (258, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (259, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (260, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (261, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (262, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (263, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (264, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (265, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (266, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (267, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (268, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (269, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (270, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (271, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (272, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (273, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (274, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (275, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (276, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (277, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (278, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (279, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (280, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (281, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (282, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (283, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (284, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (285, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (286, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (287, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (288, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (289, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (290, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (291, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (292, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (293, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (294, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (295, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (296, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (297, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (298, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (299, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (300, NULL, NULL, NULL, NULL, 1, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11423372_2557730_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (99, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, NULL, NULL, NULL, 1, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (113, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (114, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (192, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (201, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (202, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (203, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (204, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (205, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (206, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (207, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (208, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (209, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (210, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (211, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (212, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (213, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (214, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (215, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (216, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (217, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (218, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (219, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (220, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (221, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (222, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (223, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (224, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (225, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (226, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (227, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (228, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (229, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (230, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (231, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (232, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (233, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (234, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (235, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (236, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (237, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (238, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (239, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (240, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (241, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (242, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (243, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (244, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (245, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (246, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (247, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (248, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (249, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (250, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (251, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (252, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (253, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (254, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (255, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (256, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (257, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (258, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (259, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (260, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (261, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (262, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (263, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (264, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (265, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (266, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (267, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (268, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (269, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (270, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (271, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (272, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (273, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (274, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (275, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (276, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (277, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (278, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (279, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (280, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (281, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (282, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (283, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (284, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (285, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (286, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (287, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (288, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (289, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (290, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (291, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (292, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (293, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (294, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (295, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (296, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (297, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (298, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (299, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (300, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11429952_2553666_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (201, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (202, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (203, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (204, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (205, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (206, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (207, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (208, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (209, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (210, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (211, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (212, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (213, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (214, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (215, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (216, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (217, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (218, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (219, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (220, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (221, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (222, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (223, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (224, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (225, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (226, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (227, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (228, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (229, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (230, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (231, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (232, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (233, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (234, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (235, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (236, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (237, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (238, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (239, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (240, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (241, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (242, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (243, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (244, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (245, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (246, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (247, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (248, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (249, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (250, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (251, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (252, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (253, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (254, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (255, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (256, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (257, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (258, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (259, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (260, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (261, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (262, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (263, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (264, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (265, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (266, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (267, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (268, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (269, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (270, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (271, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (272, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (273, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (274, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (275, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (276, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (277, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (278, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (279, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (280, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (281, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (282, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (283, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (284, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (285, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (286, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (287, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (288, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (289, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (290, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (291, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (292, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (293, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (294, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (295, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (296, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (297, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (298, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (299, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (300, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11432693_2577788_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (10, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11433437_2575962_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (93, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11433437_2575962_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (94, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11433437_2575962_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (95, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11433437_2575962_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (101, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (125, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (161, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, NULL, NULL, NULL, 1, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (163, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (164, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (201, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (202, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (203, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (204, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (205, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (206, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (207, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (208, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (209, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (210, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (211, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (212, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (213, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (214, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (215, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (216, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (217, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (218, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (219, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (220, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (221, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (222, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (223, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (224, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (225, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (226, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (227, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (228, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (229, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (230, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (231, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (232, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (233, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (234, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (235, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (236, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (237, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (238, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (239, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (240, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (241, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (242, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (243, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (244, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (245, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (246, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (247, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (248, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (249, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (250, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (251, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (252, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (253, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (254, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (255, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (256, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (257, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (258, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (259, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (260, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (261, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (262, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (263, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (264, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (265, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (266, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (267, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (268, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (269, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (270, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (271, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (272, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (273, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (274, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (275, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (276, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (277, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (278, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (279, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (280, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (281, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (282, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (283, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (284, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (285, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (286, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (287, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (288, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (289, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (290, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (291, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (292, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (293, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (294, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (295, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (296, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (297, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (298, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (299, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (300, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11433437_2575962_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11435713_2542933_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (88, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11435713_2542933_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (89, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (93, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11435713_2542933_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (94, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, '11435713_2542933_20111019', 1, 1, 1, 3);
INSERT INTO fc_raw VALUES (95, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, '11435713_2542933_20111019', 1, 1, 1, 3);
INSERT INTO fc_raw VALUES (103, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11435713_2542933_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (113, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (114, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (122, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (124, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (179, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (201, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (202, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (203, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (204, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (205, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (206, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (207, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (208, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11435713_2542933_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (209, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11435713_2542933_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (210, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (211, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (212, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (213, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (214, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (215, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (216, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (217, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (218, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (219, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (220, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (221, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (222, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (223, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (224, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (225, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (226, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (227, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (228, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (229, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (230, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (231, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (232, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (233, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (234, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (235, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (236, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (237, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (238, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (239, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (240, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (241, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (242, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (243, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (244, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (245, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (246, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (247, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (248, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (249, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (250, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (251, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (252, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (253, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (254, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (255, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (256, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (257, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (258, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (259, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (260, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (261, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (262, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (263, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (264, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (265, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (266, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (267, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (268, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (269, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (270, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (271, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (272, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (273, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (274, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (275, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (276, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (277, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (278, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (279, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (280, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (281, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (282, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (283, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (284, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (285, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (286, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (287, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (288, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (289, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (290, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (291, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (292, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (293, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (294, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (295, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (296, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (297, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (298, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (299, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (300, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11435713_2542933_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (84, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '11436649_2532498_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (102, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, '11436649_2532498_20111019', 1, 1, 1, 3);
INSERT INTO fc_raw VALUES (103, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, '11436649_2532498_20111019', 1, 1, 1, 3);
INSERT INTO fc_raw VALUES (104, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (105, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (112, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (113, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (164, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (177, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (178, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (201, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (202, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (203, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (204, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (205, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (206, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (207, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (208, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (209, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (210, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (211, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (212, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (213, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (214, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (215, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (216, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (217, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (218, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (219, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (220, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (221, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (222, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (223, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (224, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (225, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (226, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (227, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (228, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (229, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (230, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (231, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (232, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (233, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (234, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (235, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (236, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (237, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (238, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (239, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (240, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (241, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (242, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (243, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (244, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (245, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (246, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (247, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (248, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (249, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (250, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (251, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (252, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (253, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (254, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (255, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (256, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (257, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (258, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (259, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (260, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (261, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (262, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (263, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (264, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (265, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (266, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (267, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (268, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (269, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (270, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (271, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (272, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (273, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (274, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (275, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (276, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (277, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (278, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (279, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (280, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (281, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (282, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (283, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (284, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (285, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (286, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (287, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (288, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (289, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (290, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (291, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (292, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (293, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (294, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (295, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (296, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (297, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (298, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (299, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (300, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11436649_2532498_20111019', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (100, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (201, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (202, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (203, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (204, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (205, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (206, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (207, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (208, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (209, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (210, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (211, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (212, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (213, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (214, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (215, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (216, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (217, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (218, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (219, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (220, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (221, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (222, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (223, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (224, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (225, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (226, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (227, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (228, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (229, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (230, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (231, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (232, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (233, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (234, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (235, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (236, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (237, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (238, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (239, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (240, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (241, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (242, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (243, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (244, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (245, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (246, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (247, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (248, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (249, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (250, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (251, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (252, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (253, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (254, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (255, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (256, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (257, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (258, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (259, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (260, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (261, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (262, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (263, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (264, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (265, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (266, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (267, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (268, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (269, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (270, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (271, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (272, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (273, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (274, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (275, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (276, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (277, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (278, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (279, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (280, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (281, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (282, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (283, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (284, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (285, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (286, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (287, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (288, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (289, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (290, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (291, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (292, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (293, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (294, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (295, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (296, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (297, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (298, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (299, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (300, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11446765_2574846_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, NULL, 1, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (201, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (202, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (203, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (204, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (205, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (206, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (207, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (208, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (209, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (210, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (211, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (212, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (213, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (214, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (215, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (216, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (217, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (218, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (219, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (220, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (221, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (222, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (223, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (224, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (225, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (226, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (227, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (228, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (229, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (230, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (231, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (232, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (233, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (234, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (235, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (236, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (237, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (238, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (239, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (240, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (241, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (242, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (243, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (244, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (245, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (246, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (247, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (248, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (249, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (250, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (251, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (252, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (253, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (254, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (255, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (256, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (257, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (258, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (259, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (260, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (261, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (262, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (263, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (264, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (265, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (266, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (267, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (268, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (269, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (270, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (271, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (272, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (273, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (274, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (275, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (276, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (277, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (278, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (279, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (280, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (281, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (282, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (283, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (284, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (285, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (286, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (287, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (288, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (289, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (290, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (291, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (292, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (293, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (294, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (295, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (296, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (297, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (298, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (299, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (300, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11448939_2575056_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (32, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (33, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (37, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, NULL, NULL, NULL, 1, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (64, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, NULL, NULL, 1, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (71, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (133, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (134, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (135, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (136, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (164, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (165, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (184, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (185, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (187, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (201, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (202, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (203, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (204, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (205, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (206, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (207, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (208, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (209, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (210, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (211, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (212, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (213, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (214, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (215, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (216, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (217, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (218, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (219, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (220, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (221, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (222, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (223, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (224, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (225, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (226, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (227, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (228, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (229, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (230, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (231, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (232, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (233, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (234, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (235, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (236, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (237, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (238, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (239, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (240, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (241, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (242, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (243, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (244, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (245, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (246, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (247, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (248, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (249, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (250, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (251, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (252, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (253, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (254, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (255, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (256, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (257, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (258, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (259, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (260, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (261, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (262, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (263, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (264, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (265, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (266, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (267, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (268, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (269, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (270, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (271, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (272, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (273, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (274, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (275, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (276, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (277, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (278, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (279, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (280, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (281, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (282, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '11449658_2575100_20111020', 1, NULL, 1, 2);
INSERT INTO fc_raw VALUES (283, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (284, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (285, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (286, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (287, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (288, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (289, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (290, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (291, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (292, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (293, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (294, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (295, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (296, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (297, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (298, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (299, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (300, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11449658_2575100_20111020', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11523869_2885908_20110516', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', NULL, NULL, NULL, NULL);
INSERT INTO fc_raw VALUES (8, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525063_2838692_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11525569_2839946_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11541568_3012799_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11542081_3012737_20120626', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 2);
INSERT INTO fc_raw VALUES (72, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11543775_2834874_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11544194_2841099_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11547087_2834287_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (51, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (69, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (83, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (146, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (152, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (153, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (154, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (155, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (156, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (157, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (158, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (159, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (160, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (161, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (162, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (163, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (164, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (165, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (166, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (167, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (168, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (169, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (170, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (171, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (172, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (173, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (174, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (175, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (176, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (177, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (178, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (179, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (180, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (181, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (182, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (183, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (184, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (185, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (186, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (187, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (188, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (189, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (190, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (191, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (192, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (193, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (194, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (195, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (196, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (197, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (198, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (199, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (200, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (201, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (202, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (203, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (204, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (205, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (206, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (207, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (208, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (209, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (210, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (211, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (212, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (213, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (214, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (215, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (216, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (217, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (218, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (219, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (220, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (221, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (222, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (223, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (224, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (225, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (226, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (227, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (228, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (229, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (230, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (231, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (232, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (233, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (234, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (235, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (236, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (237, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (238, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (239, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (240, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (241, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (242, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (243, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (244, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (245, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (246, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (247, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (248, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (249, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (250, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (251, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (252, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (253, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (254, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (255, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (256, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (257, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (258, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (259, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (260, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (261, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (262, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (263, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (264, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (265, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (266, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (267, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (268, NULL, NULL, NULL, NULL, NULL, NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (269, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (270, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (271, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (272, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (273, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (274, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (275, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (276, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (277, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (278, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (279, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (280, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (281, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (282, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (283, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (284, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (285, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (286, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (287, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (288, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (289, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (290, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (291, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (292, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (293, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (294, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (295, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (296, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (297, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (298, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (299, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (300, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11548338_2840215_20110517', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (2, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (3, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (4, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (5, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (6, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (7, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (8, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (9, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (10, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (11, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (12, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (13, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (14, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (15, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (16, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (17, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (18, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (19, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (20, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (21, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (22, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (23, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (24, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (25, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (26, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (27, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (28, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (29, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (30, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (31, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (32, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (33, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (34, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (35, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (36, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (37, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (38, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (39, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (40, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (41, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (42, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (43, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (44, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (45, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (46, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (47, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (48, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (49, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (50, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (51, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (52, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (53, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (54, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (55, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (56, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (57, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (58, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (59, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (60, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (61, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (62, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (63, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (64, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (65, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (66, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (67, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (68, NULL, NULL, NULL, NULL, 1, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (69, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (70, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (71, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (72, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (73, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (74, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (75, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (76, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (77, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (78, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (79, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (80, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (81, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (82, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (83, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (84, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (85, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (86, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (87, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (88, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (89, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (90, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (91, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (92, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (93, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (94, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (95, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (96, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (97, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (98, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (99, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (100, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (101, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (102, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (103, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (104, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (105, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (106, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (107, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (108, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (109, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (110, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (111, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (112, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (113, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (114, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (115, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (116, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (117, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (118, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (119, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (120, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (121, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (122, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (123, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (124, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (125, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (126, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (127, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (128, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (129, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (130, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (131, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (132, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (133, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (134, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (135, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (136, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (137, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (138, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (139, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (140, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (141, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (142, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (143, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (144, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (145, NULL, NULL, NULL, NULL, NULL, 1, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, 1, NULL, 2);
INSERT INTO fc_raw VALUES (146, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (147, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (148, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (149, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (150, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUES (151, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '11677575_2102972_20110822', 1, NULL, NULL, 1);
INSERT INTO fc_raw VALUE