'''
Python script to generate BA figure MBC-2627-002.

Modified by Chris Turnadge from a script originally created by Luk Peeters 
which was used to create BA figure GLO-262-013.
'''

import numpy as np
import pandas as pd
from BA_visualisation import *

plt.ion()

nrow = 2
ncol = 3
size = (6.6, 8.0)

recs = ['RN30203', 'RN66782', 'RN87532']

hsus = ['Walloon Coal Measures', 'Hutton Sandstone', 'Main Range Volcanics' ]
ax1   = {}
ax2   = {}

fig1 = plt.figure(figsize=size, num='MBC2627002')

for i, (rec,hsu) in enumerate( zip( recs, hsus ) ):
    RN = pd.read_csv( rec + '.csv')
    time = 1996 + np.arange( len( RN['Date'] ) )    
    diff = -RN['Baseline']--RN['CRDP']
    
    ax1[rec] = plt.subplot(nrow,ncol,1+i)
    plt.title('(%s) %s' % (letters[i], rec+' ('+hsu+')' ), 
              fontproperties=BA_font(), loc='center', y=1.03 )
    
    plt.text(0.5,0.5,'realisation 1',
             rotation=45,
             verticalalignment='center',
             horizontalalignment='center',
             fontproperties=BA_font(s=10,fweight='bold'),
             transform=ax1[rec].transAxes,
             color='k',
             alpha=0.2)
    plt.plot( time, -RN['Baseline'], 
             linestyle='-', color=BA_colors(picker=2), label='Baseline')
    plt.plot( time, -RN['CRDP'], 
             linestyle='-', color=BA_colors(picker=3), label='CRDP')
    plt.plot( [ time[np.argmax(diff)], time[np.argmax(diff)], ],
              [ -RN['Baseline'][np.argmax(diff)], -RN['CRDP'][np.argmax(diff)] ], 
              linestyle=':', marker='o',color=BA_colors(picker=5), 
              ms=4, mew=0.1, label='dmax')
    if i in [0,3]:
        plt.ylabel('Drawdown (m)', fontproperties=BA_font())
    plt.xlim(1995,2102)
    ax1[rec].xaxis.set_major_locator(MaxNLocator(nbins=5))
    ax1[rec].set_xticklabels(ax1[rec].get_xticks(), size=8, fontproperties=BA_font())
    ax1[rec].set_yticklabels(ax1[rec].get_yticks(), size=8, fontproperties=BA_font())
    ax1[rec].xaxis.set_major_formatter(FormatStrFormatter("%d"))
    ax1[rec].yaxis.grid(which='major', linestyle='-', color=BA_colors(name='Grid'))
    ax1[rec].tick_params(axis='y', left='off', right='off')
    adjust_spines(ax1[rec], ['bottom'])
    if i==0:
        plt.legend()
        ax1[rec].legend(loc='upper left', frameon=False, prop=BA_font(), 
                   bbox_to_anchor=(-0.02, -0.2, 1.25, .1), ncol=3, 
                   borderaxespad=-0.5, handletextpad=0.2)
    
    
    ax2[rec] = plt.subplot(nrow,ncol,4+i)
    plt.title('(%s) %s' % (letters[3+i], rec+' ('+hsu+')'), 
              fontproperties=BA_font(), loc='center', y=1.03)
    
    plt.text(0.5,0.5,'realisation 1',
             rotation=45,
             verticalalignment='center',
             horizontalalignment='center',
             fontproperties=BA_font(s=10,fweight='bold'),
             transform=ax2[rec].transAxes,
             color='k',
             alpha=0.2)
    plt.plot( time, diff, 
             linestyle='-', color=BA_colors(picker=1), label='Baseline-CRDP')
    plt.plot( [ time[np.argmax(diff)], time[np.argmax(diff)], ],
              [ 0, diff.max() ], 
              linestyle=':', marker='o',color=BA_colors(picker=5), ms=4, mew=0.1, label='dmax')
    if i in [0,3]:
        plt.ylabel('Additional drawdown (m)', fontproperties=BA_font())
    plt.xlim(1995,2102)
    ax2[rec].xaxis.set_major_locator(MaxNLocator(nbins=5))
    ax2[rec].set_ylim( [ ax2[rec].get_ylim()[0]-ax2[rec].get_yticks()[1],
                         ax2[rec].get_ylim()[1] ] )    
    ax2[rec].set_xticklabels(ax2[rec].get_xticks(), size=8, fontproperties=BA_font())
    ax2[rec].set_yticklabels(ax2[rec].get_yticks(), size=8, fontproperties=BA_font())
    ax2[rec].xaxis.set_major_formatter(FormatStrFormatter("%d"))
    ax2[rec].yaxis.grid(which='major', linestyle='-', color=BA_colors(name='Grid'))
    ax2[rec].tick_params(axis='y', left='off', right='off')
    adjust_spines(ax2[rec], ['bottom'])
    if i==0:
        plt.legend()
        ax2[rec].legend(loc='upper left', frameon=False, prop=BA_font(), 
                   bbox_to_anchor=(-0.02, -0.2, 1.25, .1), ncol=2, 
                   borderaxespad=-0.5, handletextpad=0.2)

plt.text( 0.58, -1.47, 'MBC-2627-002', fontproperties=BA_font(),
         transform=ax1[rec].transAxes, color='k')

plt.subplots_adjust( left=0.10, right=0.95, top=0.95, bottom=0.08, wspace=0.3, hspace=0.3 )
fig1.savefig('MBC-2627-002.png', format='png', dpi=600)
print 'Created MBC-2627-002.png'
plt.close('all')


